/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProductAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T1 (j INT, k INT, a INT, b Decimal(4,2), c TINYINT,d SMALLINT,e BIGINT,f FLOAT,h DOUBLE,PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.a.aggregate-function'='product', 'fields.b.aggregate-function'='product', 'fields.c.aggregate-function'='product', 'fields.d.aggregate-function'='product', 'fields.e.aggregate-function'='product', 'fields.f.aggregate-function'='product','fields.h.aggregate-function'='product');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("ALTER TABLE T1 MODIFY b DECIMAL(5, 3)", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE)),(1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.11 AS DOUBLE)), (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 6, new BigDecimal("11.110"), (byte)2, (short)-2, 1000000000000000L, Float.valueOf(-0.0f), -1.3676310000000003})});
        Assertions.assertThat(this.batchSql("SELECT f,e FROM T1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{Float.valueOf(-0.0f), 1000000000000000L})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 1, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 6, new BigDecimal("11.10"), (byte)2, (short)-2, 1000000000000000L, Float.valueOf(-1.2321f), -1.3676310000000003})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE T1 SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 1, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 2, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 6, new BigDecimal("11.10"), (byte)2, (short)-2, 1000000000000000L, Float.valueOf(-1.2321f), -1.3676310000000003}), Row.of((Object[])new Object[]{1, 3, 12, new BigDecimal("11.10"), (byte)2, (short)-2, 1000000000000000L, Float.valueOf(-1.2321f), -1.3676310000000003})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("T1").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

