/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.utils.RoaringBitmap32;
import org.apache.paimon.utils.RoaringBitmap64;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoaringBitmapAggAggregationITCase
extends CatalogITCaseBase {
    @Test
    public void testRoaring32BitmapAgg() throws IOException {
        this.sql("CREATE TABLE test_rbm64(  id INT PRIMARY KEY NOT ENFORCED,  f0 VARBINARY) WITH (  'merge-engine' = 'aggregation',  'fields.f0.aggregate-function' = 'rbm32')", new Object[0]);
        byte[] v1Bytes = RoaringBitmap32.bitmapOf((int[])new int[]{1}).serialize();
        byte[] v2Bytes = RoaringBitmap32.bitmapOf((int[])new int[]{2}).serialize();
        byte[] v3Bytes = RoaringBitmap32.bitmapOf((int[])new int[]{3}).serialize();
        byte[] v4Bytes = RoaringBitmap32.bitmapOf((int[])new int[]{1, 2}).serialize();
        byte[] v5Bytes = RoaringBitmap32.bitmapOf((int[])new int[]{2, 3}).serialize();
        String v1 = Hex.encodeHexString((byte[])v1Bytes).toUpperCase();
        String v2 = Hex.encodeHexString((byte[])v2Bytes).toUpperCase();
        String v3 = Hex.encodeHexString((byte[])v3Bytes).toUpperCase();
        this.sql("INSERT INTO test_rbm64 VALUES (1, CAST (NULL AS VARBINARY)), (2, CAST (x'" + v1 + "' AS VARBINARY)), (3, CAST (x'" + v2 + "' AS VARBINARY))", new Object[0]);
        List<Row> result = this.queryAndSort("SELECT * FROM test_rbm64");
        this.checkOneRecord(result.get(0), 1, null);
        this.checkOneRecord(result.get(1), 2, v1Bytes);
        this.checkOneRecord(result.get(2), 3, v2Bytes);
        this.sql("INSERT INTO test_rbm64 VALUES (1, CAST (x'" + v1 + "' AS VARBINARY)), (2, CAST (x'" + v2 + "' AS VARBINARY)), (2, CAST (x'" + v2 + "' AS VARBINARY)), (3, CAST (x'" + v3 + "' AS VARBINARY))", new Object[0]);
        result = this.queryAndSort("SELECT * FROM test_rbm64");
        this.checkOneRecord(result.get(0), 1, v1Bytes);
        this.checkOneRecord(result.get(1), 2, v4Bytes);
        this.checkOneRecord(result.get(2), 3, v5Bytes);
    }

    @Test
    public void testRoaring64BitmapAgg() throws IOException {
        this.sql("CREATE TABLE test_rbm64(  id INT PRIMARY KEY NOT ENFORCED,  f0 VARBINARY) WITH (  'merge-engine' = 'aggregation',  'fields.f0.aggregate-function' = 'rbm64')", new Object[0]);
        byte[] v1Bytes = RoaringBitmap64.bitmapOf((long[])new long[]{1L}).serialize();
        byte[] v2Bytes = RoaringBitmap64.bitmapOf((long[])new long[]{2L}).serialize();
        byte[] v3Bytes = RoaringBitmap64.bitmapOf((long[])new long[]{3L}).serialize();
        byte[] v4Bytes = RoaringBitmap64.bitmapOf((long[])new long[]{1L, 2L}).serialize();
        byte[] v5Bytes = RoaringBitmap64.bitmapOf((long[])new long[]{2L, 3L}).serialize();
        String v1 = Hex.encodeHexString((byte[])v1Bytes).toUpperCase();
        String v2 = Hex.encodeHexString((byte[])v2Bytes).toUpperCase();
        String v3 = Hex.encodeHexString((byte[])v3Bytes).toUpperCase();
        this.sql("INSERT INTO test_rbm64 VALUES (1, CAST (NULL AS VARBINARY)), (2, CAST (x'" + v1 + "' AS VARBINARY)), (3, CAST (x'" + v2 + "' AS VARBINARY))", new Object[0]);
        List<Row> result = this.queryAndSort("SELECT * FROM test_rbm64");
        this.checkOneRecord(result.get(0), 1, null);
        this.checkOneRecord(result.get(1), 2, v1Bytes);
        this.checkOneRecord(result.get(2), 3, v2Bytes);
        this.sql("INSERT INTO test_rbm64 VALUES (1, CAST (x'" + v1 + "' AS VARBINARY)), (2, CAST (x'" + v2 + "' AS VARBINARY)), (2, CAST (x'" + v2 + "' AS VARBINARY)), (3, CAST (x'" + v3 + "' AS VARBINARY))", new Object[0]);
        result = this.queryAndSort("SELECT * FROM test_rbm64");
        this.checkOneRecord(result.get(0), 1, v1Bytes);
        this.checkOneRecord(result.get(1), 2, v4Bytes);
        this.checkOneRecord(result.get(2), 3, v5Bytes);
    }

    private void checkOneRecord(Row row, int id, byte[] expected) {
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)id);
        Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)expected);
    }
}

