/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SumAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T1 (j INT, k INT, a INT, b Decimal(4,2), c TINYINT,d SMALLINT,e BIGINT,f FLOAT,h DOUBLE,PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.a.aggregate-function'='sum', 'fields.b.aggregate-function'='sum', 'fields.c.aggregate-function'='sum', 'fields.d.aggregate-function'='sum', 'fields.e.aggregate-function'='sum', 'fields.f.aggregate-function'='sum','fields.h.aggregate-function'='sum');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("INSERT INTO T1 VALUES (1, 2, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE)),(1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.11 AS DOUBLE)), (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE))", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 5, new BigDecimal("12.11"), (byte)4, (short)2, 10101000L, Float.valueOf(0.0f), 1.11})});
        Assertions.assertThat(this.batchSql("SELECT f,e FROM T1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{Float.valueOf(0.0f), 10101000L})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 1, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 6, new BigDecimal("12.11"), (byte)4, (short)2, 10101000L, Float.valueOf(0.0f), 1.11})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE T1 SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 1, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 2, 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), CAST(NULL AS FLOAT), CAST(1.11 AS DOUBLE))", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 3, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), -1.11, CAST(-1.11 AS DOUBLE))", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 6, new BigDecimal("12.11"), (byte)4, (short)2, 10101000L, Float.valueOf(0.0f), 1.11}), Row.of((Object[])new Object[]{1, 3, 7, new BigDecimal("12.11"), (byte)4, (short)2, 10101000L, Float.valueOf(0.0f), 1.11})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("T1").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

