/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.utils.BlockingIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SumRetractionAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE T (k INT,b Decimal(12, 2),PRIMARY KEY (k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'changelog-producer' = 'full-compaction','fields.b.aggregate-function'='sum');");
    }

    @Test
    public void testRetraction() throws Exception {
        this.sql("CREATE TABLE INPUT (k INT,b INT,PRIMARY KEY (k) NOT ENFORCED);", new Object[0]);
        CloseableIterator<Row> insert = this.streamSqlIter("INSERT INTO T SELECT k, SUM(b) FROM INPUT GROUP BY k;", new Object[0]);
        BlockingIterator<Row, Row> select = this.streamSqlBlockIter("SELECT * FROM T", new Object[0]);
        this.sql("INSERT INTO INPUT VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat((List)select.collect(2)).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, BigDecimal.valueOf(100L, 2)}), Row.of((Object[])new Object[]{2, BigDecimal.valueOf(200L, 2)})});
        this.sql("INSERT INTO INPUT VALUES (1, 3), (2, 4)", new Object[0]);
        Assertions.assertThat((List)select.collect(4)).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1, BigDecimal.valueOf(100L, 2)}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{1, BigDecimal.valueOf(300L, 2)}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2, BigDecimal.valueOf(200L, 2)}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2, BigDecimal.valueOf(400L, 2)})});
        select.close();
        insert.close();
    }
}

