/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.utils.ThetaSketch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThetaSketchAggAggregationITCase
extends CatalogITCaseBase {
    @Test
    public void testThetaSketchAgg() {
        this.sql("CREATE TABLE test_collect(  id INT PRIMARY KEY NOT ENFORCED,  f0 VARBINARY) WITH (  'merge-engine' = 'aggregation',  'fields.f0.aggregate-function' = 'theta_sketch')", new Object[0]);
        String str1 = Hex.encodeHexString((byte[])ThetaSketch.sketchOf((int[])new int[]{1})).toUpperCase();
        String str2 = Hex.encodeHexString((byte[])ThetaSketch.sketchOf((int[])new int[]{2})).toUpperCase();
        String str3 = Hex.encodeHexString((byte[])ThetaSketch.sketchOf((int[])new int[]{3})).toUpperCase();
        this.sql(String.format("INSERT INTO test_collect VALUES (1, CAST (NULL AS VARBINARY)),(2, CAST(x'%s' AS VARBINARY)), (3, CAST(x'%s' AS VARBINARY))", str1, str2), new Object[0]);
        List<Row> result = this.queryAndSort("SELECT * FROM test_collect");
        this.checkOneRecord(result.get(0), 1, null);
        this.checkOneRecord(result.get(1), 2, ThetaSketch.sketchOf((int[])new int[]{1}));
        this.checkOneRecord(result.get(2), 3, ThetaSketch.sketchOf((int[])new int[]{2}));
        this.sql(String.format("INSERT INTO test_collect VALUES (1, CAST (x'%s' AS VARBINARY)),(2, CAST(x'%s' AS VARBINARY)), (2, CAST(x'%s' AS VARBINARY)), (3, CAST(x'%s' AS VARBINARY))", str1, str2, str2, str3), new Object[0]);
        result = this.queryAndSort("SELECT * FROM test_collect");
        this.checkOneRecord(result.get(0), 1, ThetaSketch.sketchOf((int[])new int[]{1}));
        this.checkOneRecord(result.get(1), 2, ThetaSketch.sketchOf((int[])new int[]{1, 2}));
        this.checkOneRecord(result.get(2), 3, ThetaSketch.sketchOf((int[])new int[]{2, 3}));
    }

    private void checkOneRecord(Row row, int id, byte[] expected) {
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)id);
        Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)expected);
    }
}

