/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import java.util.Arrays;
import java.util.List;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.clone.ClonePaimonTableUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ClonePaimonTableUtilsTest {
    @Test
    public void listAllTablesForCatalog() throws Exception {
        Catalog mockPaimonCatalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)mockPaimonCatalog.listDatabases()).thenReturn(Arrays.asList("db1", "db2"));
        Mockito.when((Object)mockPaimonCatalog.listTables("db1")).thenReturn(Arrays.asList("tbl1", "tbl2", "tbl3"));
        Mockito.when((Object)mockPaimonCatalog.listTables("db2")).thenReturn(Arrays.asList("tbl1", "tbl2", "tbl3"));
        List sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, null, null);
        List<Identifier> expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl1"), Identifier.create((String)"db1", (String)"tbl2"), Identifier.create((String)"db1", (String)"tbl3"), Identifier.create((String)"db2", (String)"tbl1"), Identifier.create((String)"db2", (String)"tbl2"), Identifier.create((String)"db2", (String)"tbl3"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, null, Arrays.asList("db1.tbl3", "db2.tbl1"));
        expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl1"), Identifier.create((String)"db1", (String)"tbl2"), Identifier.create((String)"db2", (String)"tbl2"), Identifier.create((String)"db2", (String)"tbl3"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, Arrays.asList("db1.tbl3", "db2.tbl1"), null);
        expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl3"), Identifier.create((String)"db2", (String)"tbl1"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, Arrays.asList("db1.tbl3", "db2.tbl1"), Arrays.asList("db1.tbl3"));
        expectedTables = Arrays.asList(Identifier.create((String)"db2", (String)"tbl1"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
    }

    @Test
    public void listAllTablesForDatabase() throws Exception {
        Catalog mockPaimonCatalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)mockPaimonCatalog.listTables("db1")).thenReturn(Arrays.asList("tbl1", "tbl2", "tbl3"));
        List sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, (String)"db1", null, null);
        List<Identifier> expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl1"), Identifier.create((String)"db1", (String)"tbl2"), Identifier.create((String)"db1", (String)"tbl3"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, (String)"db1", null, Arrays.asList("db1.tbl1"));
        expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl2"), Identifier.create((String)"db1", (String)"tbl3"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, (String)"db1", Arrays.asList("db1.tbl1"), null);
        expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl1"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
        sourceTables = ClonePaimonTableUtils.listTables((Catalog)mockPaimonCatalog, (String)"db1", Arrays.asList("db1.tbl1", "db1.tbl2"), Arrays.asList("db1.tbl1"));
        expectedTables = Arrays.asList(Identifier.create((String)"db1", (String)"tbl2"));
        Assertions.assertThatList((List)sourceTables).containsExactlyInAnyOrderElementsOf(expectedTables);
    }
}

