/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.clone.files.ListCloneFilesFunction;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListCloneFilesFunctionTest {
    @Test
    public void testConvertSqlToPartitionPredicate() throws Exception {
        Identifier tableId = Identifier.create((String)"test_db", (String)"test_table");
        RowType partitionType = RowType.builder().field("a", (DataType)DataTypes.INT()).field("b", (DataType)DataTypes.STRING()).build();
        PartitionPredicate p = ListCloneFilesFunction.getPartitionPredicate((String)"a=1", (RowType)partitionType, (Identifier)tableId);
        Assertions.assertThat((boolean)p.test(ListCloneFilesFunctionTest.twoColumnsPartition(1, "2"))).isTrue();
        Assertions.assertThat((boolean)p.test(ListCloneFilesFunctionTest.twoColumnsPartition(2, "1"))).isFalse();
        p = ListCloneFilesFunction.getPartitionPredicate((String)"a=1 OR b='2'", (RowType)partitionType, (Identifier)tableId);
        Assertions.assertThat((boolean)p.test(ListCloneFilesFunctionTest.twoColumnsPartition(1, "1"))).isTrue();
        Assertions.assertThat((boolean)p.test(ListCloneFilesFunctionTest.twoColumnsPartition(2, "2"))).isTrue();
        Assertions.assertThat((boolean)p.test(ListCloneFilesFunctionTest.twoColumnsPartition(2, "1"))).isFalse();
        Assertions.assertThatThrownBy(() -> ListCloneFilesFunction.getPartitionPredicate((String)"a=1 OR c=1", (RowType)partitionType, (Identifier)tableId)).hasMessage("Failed to parse partition filter sql 'a=1 OR c=1' for table test_db.test_table");
        Assertions.assertThatThrownBy(() -> ListCloneFilesFunction.getPartitionPredicate((String)"a=1", (RowType)RowType.of(), (Identifier)tableId)).hasMessage("Failed to parse partition filter sql 'a=1' for table test_db.test_table");
    }

    private static BinaryRow twoColumnsPartition(int a, String b) {
        BinaryRow row = new BinaryRow(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        writer.writeInt(0, a);
        writer.writeString(1, BinaryString.fromString((String)b));
        writer.complete();
        return row;
    }
}

