/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Preconditions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactSortOperator;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableTypeInfo;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChangelogCompactSortOperatorTest {
    @Test
    public void testChangelogSorted() throws Exception {
        ChangelogCompactSortOperator operator = new ChangelogCompactSortOperator();
        OneInputStreamOperatorTestHarness<Committable, Committable> testHarness = this.createTestHarness(operator);
        Function<Integer, BinaryRow> binaryRow = i -> {
            BinaryRow row = new BinaryRow(1);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.writeInt(0, i.intValue());
            writer.complete();
            return row;
        };
        testHarness.open();
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        for (int i2 = 0; i2 <= 10; ++i2) {
            files.add(this.createDataFileMeta(i2, i2 * 100));
        }
        CommitMessageImpl onlyData = new CommitMessageImpl(binaryRow.apply(0), 0, Integer.valueOf(2), new DataIncrement(Arrays.asList((DataFileMeta)files.get(2), (DataFileMeta)files.get(1)), Collections.emptyList(), Collections.emptyList()), CompactIncrement.emptyIncrement());
        testHarness.processElement(new StreamRecord((Object)new Committable(1L, Committable.Kind.FILE, (Object)onlyData)));
        CommitMessageImpl onlyChangelogBucket0 = new CommitMessageImpl(binaryRow.apply(0), 0, Integer.valueOf(2), new DataIncrement(Collections.emptyList(), Collections.emptyList(), Arrays.asList((DataFileMeta)files.get(4), (DataFileMeta)files.get(3))), CompactIncrement.emptyIncrement());
        testHarness.processElement(new StreamRecord((Object)new Committable(1L, Committable.Kind.FILE, (Object)onlyChangelogBucket0)));
        CommitMessageImpl onlyChangelogBucket1 = new CommitMessageImpl(binaryRow.apply(0), 1, Integer.valueOf(2), new DataIncrement(Collections.emptyList(), Collections.emptyList(), Arrays.asList((DataFileMeta)files.get(7), (DataFileMeta)files.get(8))), CompactIncrement.emptyIncrement());
        testHarness.processElement(new StreamRecord((Object)new Committable(1L, Committable.Kind.FILE, (Object)onlyChangelogBucket1)));
        CommitMessageImpl mixed = new CommitMessageImpl(binaryRow.apply(0), 1, Integer.valueOf(2), new DataIncrement(Arrays.asList((DataFileMeta)files.get(10), (DataFileMeta)files.get(9)), Collections.emptyList(), Arrays.asList((DataFileMeta)files.get(6), (DataFileMeta)files.get(5))), CompactIncrement.emptyIncrement());
        testHarness.processElement(new StreamRecord((Object)new Committable(1L, Committable.Kind.FILE, (Object)mixed)));
        testHarness.prepareSnapshotPreBarrier(1L);
        ArrayList output = new ArrayList(testHarness.getOutput());
        Assertions.assertThat(output).hasSize(4);
        ArrayList<CommitMessageImpl> actual = new ArrayList<CommitMessageImpl>();
        for (Object o : output) {
            actual.add((CommitMessageImpl)((Committable)((StreamRecord)o).getValue()).wrappedCommittable());
        }
        Assertions.assertThat(actual.get(0)).isEqualTo((Object)onlyData);
        Assertions.assertThat(actual.get(1)).isEqualTo((Object)new CommitMessageImpl(binaryRow.apply(0), 1, Integer.valueOf(2), new DataIncrement(Arrays.asList((DataFileMeta)files.get(10), (DataFileMeta)files.get(9)), Collections.emptyList(), Collections.emptyList()), CompactIncrement.emptyIncrement()));
        Assertions.assertThat(actual.get(2)).isEqualTo((Object)new CommitMessageImpl(binaryRow.apply(0), 0, Integer.valueOf(2), new DataIncrement(Collections.emptyList(), Collections.emptyList(), Arrays.asList((DataFileMeta)files.get(3), (DataFileMeta)files.get(4))), CompactIncrement.emptyIncrement()));
        Assertions.assertThat(actual.get(3)).isEqualTo((Object)new CommitMessageImpl(binaryRow.apply(0), 1, Integer.valueOf(2), new DataIncrement(Collections.emptyList(), Collections.emptyList(), Arrays.asList((DataFileMeta)files.get(5), (DataFileMeta)files.get(6), (DataFileMeta)files.get(7), (DataFileMeta)files.get(8))), CompactIncrement.emptyIncrement()));
        testHarness.close();
    }

    private DataFileMeta createDataFileMeta(int mb, long creationMillis) {
        return DataFileMeta.create((String)UUID.randomUUID().toString(), (long)MemorySize.ofMebiBytes((long)mb).getBytes(), (long)0L, null, null, null, null, (long)0L, (long)0L, (long)0L, (int)0, Collections.emptyList(), (Timestamp)Timestamp.fromEpochMillis((long)creationMillis), null, null, null, null, null, null, null);
    }

    private OneInputStreamOperatorTestHarness<Committable, Committable> createTestHarness(ChangelogCompactSortOperator operator) throws Exception {
        TypeSerializer serializer = new CommittableTypeInfo().createSerializer(new ExecutionConfig());
        OneInputStreamOperatorTestHarness harness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, 1, 1, 0);
        harness.getStreamConfig().setupNetworkInputs(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull((Object)serializer)});
        harness.getStreamConfig().serializeAllConfigs();
        harness.setup(serializer);
        return harness;
    }
}

