/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactTask;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactTaskSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.StatsTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChangelogCompactTaskSerializerTest {
    private final ChangelogCompactTaskSerializer serializer = new ChangelogCompactTaskSerializer();

    @Test
    public void testSerializer() throws Exception {
        BinaryRow partition = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(partition);
        writer.writeInt(0, 0);
        writer.complete();
        ChangelogCompactTask task = new ChangelogCompactTask(1L, partition, 2, (Map)new HashMap<Integer, List<DataFileMeta>>(){
            {
                this.put(0, ChangelogCompactTaskSerializerTest.this.newFiles(20));
                this.put(1, ChangelogCompactTaskSerializerTest.this.newFiles(20));
            }
        }, new HashMap());
        ChangelogCompactTask serializeTask = this.serializer.deserialize(this.serializer.getVersion(), this.serializer.serialize(task));
        Assertions.assertThat((Object)task).isEqualTo((Object)serializeTask);
        task = new ChangelogCompactTask(2L, partition, 2, new HashMap(), (Map)new HashMap<Integer, List<DataFileMeta>>(){
            {
                this.put(0, ChangelogCompactTaskSerializerTest.this.newFiles(10));
                this.put(1, ChangelogCompactTaskSerializerTest.this.newFiles(10));
            }
        });
        serializeTask = this.serializer.deserialize(2, this.serializer.serialize(task));
        Assertions.assertThat((Object)task).isEqualTo((Object)serializeTask);
    }

    private List<DataFileMeta> newFiles(int num) {
        ArrayList<DataFileMeta> list = new ArrayList<DataFileMeta>();
        for (int i = 0; i < num; ++i) {
            list.add(this.newFile());
        }
        return list;
    }

    private DataFileMeta newFile() {
        return DataFileMeta.create((String)UUID.randomUUID().toString(), (long)0L, (long)1L, (BinaryRow)MergeTreeCompactManagerTest.row((int)0), (BinaryRow)MergeTreeCompactManagerTest.row((int)0), (SimpleStats)StatsTestUtils.newSimpleStats((int)0, (int)1), (SimpleStats)StatsTestUtils.newSimpleStats((int)0, (int)1), (long)0L, (long)1L, (long)0L, (int)0, (Long)0L, null, (FileSource)FileSource.APPEND, null, null, null);
    }
}

