/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.paimon.flink.lookup.partitioner.BucketShuffleStrategy;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BucketShuffleStrategyTest {
    @Test
    public void testConstructorWithInvalidBuckets() {
        Throwable thrown = Assertions.catchThrowable(() -> new BucketShuffleStrategy(0));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(IllegalStateException.class)).hasMessage("Number of buckets should be positive.");
    }

    @Test
    public void testGetTargetSubtaskIdWithMoreBucketsThanSubtasks() {
        BucketShuffleStrategy bucketShuffleStrategy = new BucketShuffleStrategy(10);
        int targetSubtaskId = bucketShuffleStrategy.getTargetSubtaskId(5, 12345, 4);
        Assertions.assertThat((int)targetSubtaskId).isEqualTo(1);
    }

    @Test
    public void testGetTargetSubtaskIdWithLessBucketsThanSubtasks() {
        BucketShuffleStrategy bucketShuffleStrategy1 = new BucketShuffleStrategy(3);
        int targetSubtaskId1 = bucketShuffleStrategy1.getTargetSubtaskId(2, 12345, 10);
        int expectedTargetSubtaskId1 = 2;
        Assertions.assertThat((int)targetSubtaskId1).isEqualTo(expectedTargetSubtaskId1);
        BucketShuffleStrategy bucketShuffleStrategy2 = new BucketShuffleStrategy(2);
        int targetSubtaskId2 = bucketShuffleStrategy2.getTargetSubtaskId(0, 54321, 7);
        int expectedTargetSubtaskId2 = 2;
        Assertions.assertThat((int)targetSubtaskId2).isEqualTo(expectedTargetSubtaskId2);
    }

    @Test
    public void testGetRequiredCacheBucketIdsWithMoreBucketsThanSubtasks() {
        BucketShuffleStrategy bucketShuffleStrategy = new BucketShuffleStrategy(10);
        Set bucketIds = bucketShuffleStrategy.getRequiredCacheBucketIds(1, 4);
        Assertions.assertThat((Collection)bucketIds).containsExactlyInAnyOrder((Object[])new Integer[]{1, 5, 9});
    }

    @Test
    public void testGetRequiredCacheBucketIdsWithLessBucketsThanSubtasks() {
        BucketShuffleStrategy bucketShuffleStrategy = new BucketShuffleStrategy(3);
        Set bucketIds = bucketShuffleStrategy.getRequiredCacheBucketIds(1, 10);
        Assertions.assertThat((Collection)bucketIds).containsExactlyInAnyOrder((Object[])new Integer[]{1});
    }

    @Test
    public void testSymmetryOfGetTargetSubtaskIdAndGetRequiredCacheBucketIds() {
        for (int numBuckets = 1; numBuckets < 100; ++numBuckets) {
            for (int numSubtasks = 1; numSubtasks < 100; ++numSubtasks) {
                this.testCorrectness(numBuckets, numSubtasks);
            }
        }
    }

    private void testCorrectness(int numBuckets, int numSubtasks) {
        BucketShuffleStrategy bucketShuffleStrategy = new BucketShuffleStrategy(numBuckets);
        HashSet<Integer> allTargetSubtaskIds = new HashSet<Integer>();
        for (int bucketId = 0; bucketId < numBuckets; ++bucketId) {
            for (int joinKeyHash = 0; joinKeyHash < numSubtasks; ++joinKeyHash) {
                int subtaskId = bucketShuffleStrategy.getTargetSubtaskId(bucketId, joinKeyHash, numSubtasks);
                Assertions.assertThat((int)subtaskId).isNotNegative().isLessThan(numSubtasks);
                allTargetSubtaskIds.add(subtaskId);
                Set requiredCacheBucketIds = bucketShuffleStrategy.getRequiredCacheBucketIds(subtaskId, numSubtasks);
                Assertions.assertThat((Collection)requiredCacheBucketIds).contains((Object[])new Integer[]{bucketId});
            }
        }
        Assertions.assertThat(allTargetSubtaskIds).hasSize(numSubtasks);
    }
}

