/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.rocksdb.RocksDBListState;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class RocksDBListStateTest {
    @TempDir
    Path tempDir;

    @Test
    void test() throws Exception {
        RocksDBStateFactory factory = new RocksDBStateFactory(this.tempDir.toString(), new Options(), null);
        RowType keyType = RowType.of((DataType[])new DataType[]{DataTypes.STRING()});
        RowType valueType = RowType.of((DataType[])new DataType[]{DataTypes.STRING()});
        RocksDBListState listState = factory.listState("test", (Serializer)new InternalRowSerializer(keyType), (Serializer)new InternalRowSerializer(valueType), 1L);
        GenericRow key = this.row("aaa");
        listState.add((Object)key, (Object)this.row("1"));
        List result = listState.get((Object)key);
        Assertions.assertThat(this.getString(result)).containsExactlyInAnyOrder((Object[])new String[]{"1"});
        listState.add((Object)key, (Object)this.row("2,3"));
        Assertions.assertThat(this.getString(listState.get((Object)key))).containsExactlyInAnyOrder(new Object[]{"1", "2,3"});
        listState.add((Object)key, (Object)this.row("1"));
        Assertions.assertThat(this.getString(listState.get((Object)key))).containsExactlyInAnyOrder(new Object[]{"1", "2,3", "1"});
        Assertions.assertThat((List)listState.get((Object)this.row("bbb"))).isEmpty();
        factory.close();
    }

    public GenericRow row(String value) {
        return GenericRow.of((Object[])new Object[]{this.bs(value)});
    }

    public GenericRow row(String value, RowKind kind) {
        GenericRow row = GenericRow.of((Object[])new Object[]{this.bs(value)});
        row.setRowKind(kind);
        return row;
    }

    public BinaryString bs(String v) {
        return BinaryString.fromString((String)v);
    }

    public BinaryRow write(String v) {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter write = new BinaryRowWriter(row);
        write.writeString(0, this.bs(v));
        return row;
    }

    public List<String> getString(List<InternalRow> inputs) {
        ArrayList<String> rows = new ArrayList<String>();
        for (InternalRow input : inputs) {
            rows.add(input.getString(0).toString());
        }
        return rows;
    }
}

