/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.predicate;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.predicate.SimpleSqlPredicateConvertor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SimpleSqlPredicateConvertorTest {
    RowType rowType;
    PredicateBuilder predicateBuilder;
    SimpleSqlPredicateConvertor simpleSqlPredicateConvertor;

    SimpleSqlPredicateConvertorTest() {
    }

    @BeforeEach
    public void init() throws Exception {
        this.rowType = RowType.builder().field("a", (DataType)DataTypes.INT()).field("b", (DataType)DataTypes.STRING()).field("c", (DataType)DataTypes.DATE()).field("hour", (DataType)DataTypes.STRING()).build();
        this.predicateBuilder = new PredicateBuilder(this.rowType);
        this.simpleSqlPredicateConvertor = new SimpleSqlPredicateConvertor(this.rowType);
    }

    @Test
    public void testEqual() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("`hour` ='1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.equal(this.predicateBuilder.indexOf("hour"), (Object)BinaryString.fromString((String)"1")));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate(" '2024-05-25' = c");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.equal(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testNotEqual() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a <>'1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.notEqual(this.predicateBuilder.indexOf("a"), (Object)1));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("'2024-05-25' <> c");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.notEqual(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testLessThan() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a <'1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.lessThan(this.predicateBuilder.indexOf("a"), (Object)1));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("'2024-05-25' <c ");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.greaterThan(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a <='1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.lessOrEqual(this.predicateBuilder.indexOf("a"), (Object)1));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("'2024-05-25' <= c");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.greaterOrEqual(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testGreatThan() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a >'1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.greaterThan(this.predicateBuilder.indexOf("a"), (Object)1));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("'2024-05-25' > c");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.lessThan(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testGreatEqual() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a >='1'");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.greaterOrEqual(this.predicateBuilder.indexOf("a"), (Object)1));
        predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate(" '2024-05-25' >= c");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.lessOrEqual(this.predicateBuilder.indexOf("c"), (Object)19868));
    }

    @Test
    public void testIN() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a in ('1','2')");
        ArrayList elements = Lists.newArrayList((Object[])new Object[]{1, 2});
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.in(this.predicateBuilder.indexOf("a"), (List)elements));
    }

    @Test
    public void testNotIn() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a not in ('1','2')");
        ArrayList elements = Lists.newArrayList((Object[])new Object[]{1, 2});
        Assertions.assertThat((Object)predicate).isEqualTo(this.predicateBuilder.in(this.predicateBuilder.indexOf("a"), (List)elements).negate().get());
    }

    @Test
    public void testIsNull() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a is null ");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.isNull(this.predicateBuilder.indexOf("a")));
    }

    @Test
    public void testIsNotNull() throws Exception {
        Predicate predicate = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a is not  null ");
        Assertions.assertThat((Object)predicate).isEqualTo((Object)this.predicateBuilder.isNotNull(this.predicateBuilder.indexOf("a")));
    }

    @Test
    public void testAnd() throws Exception {
        Predicate actual = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a is not null and c is null");
        Predicate expected = PredicateBuilder.and((Predicate[])new Predicate[]{this.predicateBuilder.isNotNull(this.predicateBuilder.indexOf("a")), this.predicateBuilder.isNull(this.predicateBuilder.indexOf("c"))});
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testOr() throws Exception {
        Predicate actual = this.simpleSqlPredicateConvertor.convertSqlToPredicate("a is not  null or c is null ");
        Predicate expected = PredicateBuilder.or((Predicate[])new Predicate[]{this.predicateBuilder.isNotNull(this.predicateBuilder.indexOf("a")), this.predicateBuilder.isNull(this.predicateBuilder.indexOf("c"))});
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testNOT() throws Exception {
        Predicate actual = this.simpleSqlPredicateConvertor.convertSqlToPredicate("not (a is null) ");
        Predicate expected = (Predicate)this.predicateBuilder.isNull(this.predicateBuilder.indexOf("a")).negate().get();
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testFieldNoFound() {
        Assertions.assertThatThrownBy(() -> this.simpleSqlPredicateConvertor.convertSqlToPredicate("f =1")).hasMessage("Field `f` not found");
    }

    @Test
    public void testSqlNoSupport() {
        Assertions.assertThatThrownBy(() -> this.simpleSqlPredicateConvertor.convertSqlToPredicate("substring(f,0,1) =1")).hasMessage("SUBSTRING(`f` FROM 0 FOR 1) or 1 not been supported.");
        Assertions.assertThatThrownBy(() -> this.simpleSqlPredicateConvertor.convertSqlToPredicate("b like 'x'")).hasMessage("LIKE not been supported.");
    }
}

