/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Objects;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompactManifestProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testManifestCompactProcedure() {
        this.sql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'file.format' = 'parquet', 'manifest.full-compaction-threshold-size' = '10000 T', 'bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT OVERWRITE T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT OVERWRITE T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT OVERWRITE T VALUES (1, '101', 15, '20221208'), (4, '1001', 16, '20221208'), (5, '10001', 15, '20221209')", new Object[0]);
        Assertions.assertThat((Object)this.sql("SELECT sum(num_deleted_files) FROM T$manifests", new Object[0]).get(0).getField(0)).isEqualTo((Object)9L);
        Assertions.assertThat((String)Objects.requireNonNull(this.sql("CALL sys.compact_manifest(`table` => 'default.T')", new Object[0]).get(0).getField(0)).toString()).isEqualTo("success");
        Assertions.assertThat((Object)this.sql("SELECT sum(num_deleted_files) FROM T$manifests", new Object[0]).get(0).getField(0)).isEqualTo((Object)0L);
        Assertions.assertThat((String)this.sql("SELECT * FROM T ORDER BY k", new Object[0]).toString()).isEqualTo("[+I[1, 101, 15, 20221208], +I[4, 1001, 16, 20221208], +I[5, 10001, 15, 20221209]]");
    }

    @Test
    public void testManifestCompactProcedureWithBranch() {
        this.sql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'manifest.full-compaction-threshold-size' = '10000 T', 'bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO `T` VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("CALL sys.create_tag('default.T', 'tag1', 1)", new Object[0]);
        this.sql("call sys.create_branch('default.T', 'branch1', 'tag1')", new Object[0]);
        this.sql("INSERT OVERWRITE T$branch_branch1 VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT OVERWRITE T$branch_branch1 VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT OVERWRITE T$branch_branch1 VALUES (1, '101', 15, '20221208'), (4, '1001', 16, '20221208'), (5, '10001', 15, '20221209')", new Object[0]);
        Assertions.assertThat((Object)this.sql("SELECT sum(num_deleted_files) FROM T$branch_branch1$manifests", new Object[0]).get(0).getField(0)).isEqualTo((Object)9L);
        Assertions.assertThat((String)Objects.requireNonNull(this.sql("CALL sys.compact_manifest(`table` => 'default.T$branch_branch1')", new Object[0]).get(0).getField(0)).toString()).isEqualTo("success");
        Assertions.assertThat((Object)this.sql("SELECT sum(num_deleted_files) FROM T$branch_branch1$manifests", new Object[0]).get(0).getField(0)).isEqualTo((Object)0L);
        Assertions.assertThat((String)this.sql("SELECT * FROM T$branch_branch1 ORDER BY k", new Object[0]).toString()).isEqualTo("[+I[1, 101, 15, 20221208], +I[4, 1001, 16, 20221208], +I[5, 10001, 15, 20221209]]");
    }
}

