/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpireTagsProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testExpireTagsByTagCreateTimeAndTagTimeRetained() throws Exception {
        this.sql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1', 'write-only'='true')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        SnapshotManager snapshotManager = table.snapshotManager();
        for (int i = 1; i <= 5; ++i) {
            this.sql("INSERT INTO T VALUES ('" + i + "', '" + i + "')", new Object[0]);
        }
        this.checkSnapshots(snapshotManager, 1, 5);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-1', snapshot_id => 1)", new Object[0]);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-2', snapshot_id => 2, time_retained => '1h')", new Object[0]);
        Assertions.assertThat(this.sql("CALL sys.expire_tags(`table` => 'default.T')", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"No expired tags."})});
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-3', snapshot_id => 3, time_retained => '1s')", new Object[0]);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-4', snapshot_id => 4, time_retained => '1s')", new Object[0]);
        Thread.sleep(2000L);
        Assertions.assertThat(this.sql("CALL sys.expire_tags(`table` => 'default.T')", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"tag-3"}), Row.of((Object[])new Object[]{"tag-4"})});
    }

    @Test
    public void testExpireTagsByOlderThanTime() throws Exception {
        this.sql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1', 'write-only'='true')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        SnapshotManager snapshotManager = table.snapshotManager();
        for (int i = 1; i <= 5; ++i) {
            this.sql("INSERT INTO T VALUES ('" + i + "', '" + i + "')", new Object[0]);
        }
        this.checkSnapshots(snapshotManager, 1, 5);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-1', snapshot_id => 1)", new Object[0]);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-2', snapshot_id => 2, time_retained => '1d')", new Object[0]);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-3', snapshot_id => 3, time_retained => '1d')", new Object[0]);
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-4', snapshot_id => 4, time_retained => '1d')", new Object[0]);
        List<Row> sql = this.sql("select count(tag_name) from `T$tags`", new Object[0]);
        Assertions.assertThat(this.sql("select count(tag_name) from `T$tags`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{4L})});
        Assertions.assertThat(this.sql("CALL sys.expire_tags(`table` => 'default.T')", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"No expired tags."})});
        LocalDateTime olderThanTime1 = table.tagManager().getOrThrow("tag-2").getTagCreateTime();
        Timestamp timestamp1 = new Timestamp(org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)olderThanTime1).getMillisecond());
        Assertions.assertThat(this.sql("CALL sys.expire_tags(`table` => 'default.T', older_than => '" + timestamp1.toString() + "')", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"tag-1"})});
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-5', snapshot_id => 5, time_retained => '1s')", new Object[0]);
        Thread.sleep(1000L);
        LocalDateTime olderThanTime2 = table.tagManager().getOrThrow("tag-4").getTagCreateTime();
        Timestamp timestamp2 = new Timestamp(org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)olderThanTime2).getMillisecond());
        Assertions.assertThat(this.sql("CALL sys.expire_tags(`table` => 'default.T', older_than => '" + timestamp2.toString() + "')", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"tag-2"}), Row.of((Object[])new Object[]{"tag-3"}), Row.of((Object[])new Object[]{"tag-5"})});
        Assertions.assertThat(this.sql("select tag_name from `T$tags`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"tag-4"})});
    }

    private void checkSnapshots(SnapshotManager sm, int earliest, int latest) throws IOException {
        Assertions.assertThat((long)sm.snapshotCount()).isEqualTo((long)(latest - earliest + 1));
        Assertions.assertThat((Long)sm.earliestSnapshotId()).isEqualTo((long)earliest);
        Assertions.assertThat((Long)sm.latestSnapshotId()).isEqualTo((long)latest);
    }
}

