/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.RESTCatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FunctionProcedureITCase
extends RESTCatalogITCaseBase {
    @Test
    public void test() throws FunctionNotExistException {
        String functionName = "test_function";
        List<Row> result = this.sql(String.format("CALL sys.create_function('%s.%s', '[{\"id\": 0, \"name\":\"length\", \"type\":\"INT\"}, {\"id\": 1, \"name\":\"width\", \"type\":\"INT\"}]','[{\"id\": 0, \"name\":\"area\", \"type\":\"BIGINT\"}]', true, 'comment', 'k1=v1,k2=v2')", "mydb", functionName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        Assertions.assertThat(this.batchSql(String.format("SHOW FUNCTIONS in %s", "mydb"), new Object[0])).contains((Object[])new Row[]{Row.of((Object[])new Object[]{functionName})});
        result = this.sql(String.format("CALL sys.alter_function('%s.%s', '{\"action\" : \"addDefinition\", \"name\" : \"flink\", \"definition\" : {\"type\" : \"file\", \"fileResources\" : [{\"resourceType\": \"JAR\", \"uri\": \"oss://mybucket/xxxx.jar\"}], \"language\": \"JAVA\", \"className\": \"xxxx\", \"functionName\": \"functionName\" } }')", "mydb", functionName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        Catalog catalog = (Catalog)this.tEnv.getCatalog("PAIMON").get();
        ObjectPath functionObjectPath = new ObjectPath("mydb", functionName);
        Assertions.assertThat(this.batchSql(String.format("SHOW FUNCTIONS in %s", "mydb"), new Object[0])).contains((Object[])new Row[]{Row.of((Object[])new Object[]{functionName})});
        CatalogFunction getFunction = catalog.getFunction(functionObjectPath);
        Assertions.assertThat((String)getFunction.getClassName()).isEqualTo("xxxx");
        result = this.sql(String.format("CALL sys.drop_function('%s.%s')", "mydb", functionName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        Assertions.assertThat(this.batchSql(String.format("SHOW FUNCTIONS in %s", "mydb"), new Object[0])).doesNotContain((Object[])new Row[]{Row.of((Object[])new Object[]{functionName})});
    }
}

