/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProcedureTest {
    @Test
    public void testProcedureCoverAllActions() {
        HashSet<String> expectedExclusions = new HashSet<String>();
        expectedExclusions.add("delete");
        List actionIdentifiers = FactoryUtil.discoverIdentifiers((ClassLoader)ActionFactory.class.getClassLoader(), ActionFactory.class);
        Assertions.assertThat((int)actionIdentifiers.size()).isNotZero();
        for (String identifier : actionIdentifiers) {
            if (expectedExclusions.contains(identifier)) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                    ProcedureBase cfr_ignored_0 = (ProcedureBase)FactoryUtil.discoverFactory((ClassLoader)ProcedureBase.class.getClassLoader(), ProcedureBase.class, (String)identifier);
                }).isInstanceOf(FactoryException.class)).hasMessageContaining("Could not find any factory for identifier");
                continue;
            }
            ProcedureBase procedure = (ProcedureBase)FactoryUtil.discoverFactory((ClassLoader)ProcedureBase.class.getClassLoader(), ProcedureBase.class, (String)identifier);
            Assertions.assertThat((Object)procedure).isNotNull();
        }
    }

    @Test
    public void testProcedureHasNamedArgument() {
        HashSet<String> expectedExclusions = new HashSet<String>();
        expectedExclusions.add("drop_partition");
        List identifiers = FactoryUtil.discoverIdentifiers((ClassLoader)ProcedureBase.class.getClassLoader(), ProcedureBase.class);
        Assertions.assertThat((int)identifiers.size()).isNotZero();
        for (String identifier : identifiers) {
            ProcedureBase procedure = (ProcedureBase)FactoryUtil.discoverFactory((ClassLoader)ProcedureBase.class.getClassLoader(), ProcedureBase.class, (String)identifier);
            Method method = this.getMethodFromName(procedure.getClass(), "call");
            if (expectedExclusions.contains(identifier)) {
                Assertions.assertThat((Object)method).matches(x -> !x.isAnnotationPresent(ProcedureHint.class), String.format("Procedure %s has supported named argument. Should be removed from exclusion list.", procedure.identifier()));
                continue;
            }
            Assertions.assertThat((Object)method).matches(x -> x.isAnnotationPresent(ProcedureHint.class), String.format("Procedure %s should have its call method decorated by %s.", procedure.identifier(), ProcedureHint.class.getSimpleName()));
        }
    }

    private Method getMethodFromName(Class<?> clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalStateException(String.format("Procedure class %s does not have a method named %s.", clazz.getSimpleName(), methodName));
    }
}

