/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.apache.paimon.operation.ListUnexistingFilesTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RemoveUnexistingFilesProcedureITCase
extends AbstractTestBase {
    @ParameterizedTest
    @ValueSource(ints={-1, 3})
    public void testProcedure(int bucket) throws Exception {
        Row row;
        String warehouse = this.getTempDirPath();
        int numPartitions = 2;
        int numFiles = 10;
        int[] numDeletes = new int[numPartitions];
        ListUnexistingFilesTest.prepareRandomlyDeletedTable((String)warehouse, (String)"mydb", (String)"t", (int)bucket, (int)numFiles, (int[])numDeletes);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG mycat WITH (\n  'type' = 'paimon',\n  'warehouse' = '" + warehouse + "'\n)");
        tEnv.executeSql("USE CATALOG mycat");
        int[] actual = new int[numPartitions];
        Pattern pattern = Pattern.compile("pt=(\\d+?)/");
        try (CloseableIterator it = tEnv.executeSql("CALL sys.remove_unexisting_files(`table` => 'mydb.t', `dry_run` => true, `parallelism` => 2)").collect();){
            while (it.hasNext()) {
                row = (Row)it.next();
                Matcher matcher = pattern.matcher(row.getField(0).toString());
                if (!matcher.find()) continue;
                int n = Integer.parseInt(matcher.group(1));
                actual[n] = actual[n] + 1;
            }
        }
        Assertions.assertThat((int[])actual).isEqualTo((Object)numDeletes);
        tEnv.executeSql("CALL sys.remove_unexisting_files(`table` => 'mydb.t', `parallelism` => 2)").await();
        it = tEnv.executeSql("SELECT pt, CAST(COUNT(*) AS INT) FROM mydb.t GROUP BY pt").collect();
        var10_10 = null;
        try {
            while (it.hasNext()) {
                row = (Row)it.next();
                Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)(numFiles - numDeletes[(Integer)row.getField(0)]));
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (it != null) {
                if (var10_10 != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    it.close();
                }
            }
        }
    }
}

