/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TriggerTagAutomaticCreationProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testTriggerTagAutomaticCreation() {
        this.sql("CREATE TABLE T (id INT, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 'a')", new Object[0]);
        Assertions.assertThat(this.sql("select * from `T`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, "a"})});
        Assertions.assertThat(this.sql("select tag_name from `T$tags`", new Object[0]).stream().map(Row::toString)).isNullOrEmpty();
        this.sql("alter table T set ('tag.automatic-creation'='process-time','tag.creation-period'='daily','tag.creation-delay'='10 m','tag.num-retained-max'='90')", new Object[0]);
        this.sql("CALL sys.trigger_tag_automatic_creation(`table` => 'default.T')", new Object[0]);
        ((ListAssert)Assertions.assertThat(this.sql("select tag_name from `T$tags`", new Object[0]).stream().map(Row::toString)).isNotNull()).isNotEmpty();
    }
}

