/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.WriterRefresher;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class WriterRefresherTest {
    @TempDir
    public Path tempDir;
    Catalog catalog;

    @BeforeEach
    public void before() throws Exception {
        Options options = new Options();
        options.set(CatalogOptions.WAREHOUSE, (Object)this.tempDir.toString());
        options.set(CatalogOptions.CACHE_ENABLED, (Object)false);
        CatalogContext context = CatalogContext.create((Options)options);
        this.catalog = CatalogFactory.createCatalog((CatalogContext)context);
        this.catalog.createDatabase("default", true);
    }

    @Test
    public void testDoRefresh() throws Exception {
        String detectGroups = "external-paths";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS.key(), detectGroups);
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        table1.schemaManager().commitChanges(new SchemaChange[]{SchemaChange.setOption((String)CoreOptions.DATA_FILE_EXTERNAL_PATHS.key(), (String)"external-path1"), SchemaChange.setOption((String)CoreOptions.DATA_FILE_EXTERNAL_PATHS_STRATEGY.key(), (String)"round-robin")});
        FileStoreTable table2 = this.getTable();
        HashMap<String, String> refreshedOptions = new HashMap<String, String>();
        Set<String> groups = Arrays.stream(detectGroups.split(",")).collect(Collectors.toSet());
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(groups, refreshedOptions));
        writerRefresher.tryRefresh();
        Assertions.assertThat(refreshedOptions).isEqualTo((Object)WriterRefresher.configGroups(groups, (CoreOptions)table2.coreOptions()));
        writerRefresher.tryRefresh();
    }

    @Test
    public void testRefreshWithNullConfigGroups() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(null, null));
        Assertions.assertThat((Object)writerRefresher).isNull();
    }

    @Test
    public void testRefreshWithEmptyConfigGroups() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS.key(), "");
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(null, null));
        Assertions.assertThat((Object)writerRefresher).isNull();
    }

    @Test
    public void testRefreshWithCommaOnlyConfigGroups() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS.key(), ",,,");
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        Set<String> emptyGroups = Arrays.stream(",,,".split(",")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet());
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(emptyGroups, null));
        Assertions.assertThat((Object)writerRefresher).isNull();
    }

    @Test
    public void testNoRefreshWhenNoSchemaChange() throws Exception {
        String detectGroups = "external-paths";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS.key(), detectGroups);
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        HashMap<String, String> refreshedOptions = new HashMap<String, String>();
        refreshedOptions.put("initial", "value");
        Set<String> groups = Arrays.stream(detectGroups.split(",")).collect(Collectors.toSet());
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(groups, refreshedOptions));
        writerRefresher.tryRefresh();
        Assertions.assertThat(refreshedOptions).containsEntry((Object)"initial", (Object)"value");
        Assertions.assertThat(refreshedOptions).hasSize(1);
    }

    @Test
    public void testNoRefreshWhenConfigGroupsNotChanged() throws Exception {
        String detectGroups = "external-paths";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS.key(), detectGroups);
        options.put(CoreOptions.DATA_FILE_EXTERNAL_PATHS.key(), "external-path1");
        this.createTable(options);
        FileStoreTable table1 = this.getTable();
        table1.schemaManager().commitChanges(new SchemaChange[]{SchemaChange.setOption((String)CoreOptions.DATA_FILE_EXTERNAL_PATHS.key(), (String)"external-path1"), SchemaChange.setOption((String)CoreOptions.DATA_FILE_PREFIX.key(), (String)"data1")});
        HashMap<String, String> refreshedOptions = new HashMap<String, String>();
        refreshedOptions.put("initial", "value");
        Set<String> groups = Arrays.stream(detectGroups.split(",")).collect(Collectors.toSet());
        WriterRefresher writerRefresher = WriterRefresher.create((boolean)true, (FileStoreTable)table1, (WriterRefresher.Refresher)new TestWriteRefresher(groups, refreshedOptions));
        writerRefresher.tryRefresh();
        Assertions.assertThat(refreshedOptions).containsEntry((Object)"initial", (Object)"value");
        Assertions.assertThat(refreshedOptions).hasSize(1);
    }

    private void createTable(Map<String, String> options) throws Exception {
        this.catalog.createTable(Identifier.create((String)"default", (String)"T"), Schema.newBuilder().column("a", (DataType)DataTypes.INT()).column("b", (DataType)DataTypes.INT()).options(options).build(), false);
    }

    private FileStoreTable getTable() throws Exception {
        return (FileStoreTable)this.catalog.getTable(Identifier.create((String)"default", (String)"T"));
    }

    private static class TestWriteRefresher
    implements WriterRefresher.Refresher {
        private final Set<String> groups;
        private final Map<String, String> options;

        TestWriteRefresher(Set<String> groups, Map<String, String> options) {
            this.groups = groups;
            this.options = options;
        }

        public void refresh(FileStoreTable table) {
            this.options.clear();
            if (this.groups != null) {
                this.options.putAll(WriterRefresher.configGroups(this.groups, (CoreOptions)table.coreOptions()));
            }
        }
    }
}

