/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.coordinator;

import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.coordinator.ScanCoordinationRequest;
import org.apache.paimon.flink.sink.coordinator.ScanCoordinationResponse;
import org.apache.paimon.flink.sink.coordinator.TableWriteCoordinator;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableTestBase;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.SerializationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TableWriteCoordinatorTest
extends TableTestBase {
    TableWriteCoordinatorTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLatestIdentifierAndScan(boolean initSnapshot) throws Exception {
        Identifier identifier = new Identifier("db", "table");
        Schema schema = Schema.newBuilder().column("f0", (DataType)DataTypes.INT()).build();
        this.catalog.createDatabase("db", false);
        this.catalog.createTable(identifier, schema, false);
        FileStoreTable table = this.getTable(identifier);
        if (initSnapshot) {
            this.write((Table)table, new InternalRow[]{GenericRow.of((Object[])new Object[]{1})});
        }
        TableWriteCoordinator coordinator = new TableWriteCoordinator(table);
        this.write((Table)table, new InternalRow[]{GenericRow.of((Object[])new Object[]{1})});
        Snapshot latest = (Snapshot)table.latestSnapshot().get();
        String commitUser = latest.commitUser();
        coordinator.latestCommittedIdentifier(commitUser);
        ScanCoordinationRequest request = new ScanCoordinationRequest(SerializationUtils.serializeBinaryRow((BinaryRow)BinaryRow.EMPTY_ROW), 0, false, false);
        ScanCoordinationResponse scan = coordinator.scan(request);
        Assertions.assertThat((long)scan.snapshot().id()).isEqualTo(latest.id());
        Assertions.assertThat((int)scan.extractDataFiles().size()).isEqualTo(initSnapshot ? 2 : 1);
    }

    @Test
    public void testNoManifestCache() throws Exception {
        Identifier identifier = new Identifier("db", "table");
        this.catalog.createDatabase("db", false);
        this.createTable(identifier);
        FileStoreTable table = this.getTable(identifier);
        table.setManifestCache(null);
        Assertions.assertThatThrownBy(() -> new TableWriteCoordinator(table)).isInstanceOf(NullPointerException.class);
    }
}

