/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOFinder;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.actions.HttpReportMarkDoneAction;
import org.apache.paimon.rest.TestHttpWebServer;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.SchemaUtils;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.utils.InternalRowUtilsTest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HttpReportMarkDoneActionTest {
    private static TestHttpWebServer server;
    private static final String partition = "partition";
    private static String params;
    private static final String successResponse = "{\"result\":\"success\"}";
    private static final String failedResponse = "{\"result\":\"failed\"}";
    private static FileStoreTable fileStoreTable;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void startServer() throws Exception {
        server = new TestHttpWebServer("");
        server.start();
        fileStoreTable = this.createFileStoreTable();
    }

    @After
    public void stopServer() throws Exception {
        server.stop();
    }

    @Test
    public void testHttpReportMarkDoneActionSuccessResponse() throws Exception {
        HttpReportMarkDoneAction httpReportMarkDoneAction = new HttpReportMarkDoneAction();
        httpReportMarkDoneAction.open(fileStoreTable, HttpReportMarkDoneActionTest.createCoreOptions());
        server.enqueueResponse(successResponse, Integer.valueOf(200));
        httpReportMarkDoneAction.markDone(partition);
        RecordedRequest request = server.takeRequest(10L, TimeUnit.SECONDS);
        HttpReportMarkDoneActionTest.assertRequest(request);
        String expectedResponse2 = "{\"unknow\" :\"unknow\", \"result\" :\"success\"}";
        server.enqueueResponse(expectedResponse2, Integer.valueOf(200));
        httpReportMarkDoneAction.markDone(partition);
        RecordedRequest request2 = server.takeRequest(10L, TimeUnit.SECONDS);
        HttpReportMarkDoneActionTest.assertRequest(request2);
        params = null;
        HttpReportMarkDoneAction httpReportMarkDoneAction3 = new HttpReportMarkDoneAction();
        httpReportMarkDoneAction3.open(fileStoreTable, HttpReportMarkDoneActionTest.createCoreOptions());
        server.enqueueResponse(successResponse, Integer.valueOf(200));
        httpReportMarkDoneAction3.markDone(partition);
        RecordedRequest request3 = server.takeRequest(10L, TimeUnit.SECONDS);
        HttpReportMarkDoneActionTest.assertRequest(request3);
    }

    @Test
    public void testHttpReportMarkDoneActionFailedResponse() {
        HttpReportMarkDoneAction markDoneAction = new HttpReportMarkDoneAction();
        markDoneAction.open(fileStoreTable, HttpReportMarkDoneActionTest.createCoreOptions());
        server.enqueueResponse(failedResponse, Integer.valueOf(200));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> markDoneAction.markDone(partition)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("The http-report action's response attribute `result` should be 'SUCCESS' but is 'failed'.");
        String unExpectResponse = "{\"unknow\" :\"unknow\"}";
        server.enqueueResponse(unExpectResponse, Integer.valueOf(200));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> markDoneAction.markDone(partition)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("The http-report action's response attribute `result` should be 'SUCCESS' but is 'null'.");
        server.enqueueResponse("", Integer.valueOf(200));
        Assertions.assertThatThrownBy(() -> markDoneAction.markDone(partition)).hasMessageContaining("ResponseBody is null or empty.");
        server.enqueueResponse(successResponse, Integer.valueOf(400));
        Assertions.assertThatThrownBy(() -> markDoneAction.markDone(partition)).hasMessageContaining("Response is not successful");
    }

    public static void assertRequest(RecordedRequest recordedRequest) throws JsonProcessingException {
        String requestBody = recordedRequest.getBody().readUtf8();
        HttpReportMarkDoneAction.HttpReportMarkDoneRequest request = (HttpReportMarkDoneAction.HttpReportMarkDoneRequest)server.readRequestBody(requestBody, HttpReportMarkDoneAction.HttpReportMarkDoneRequest.class);
        Assertions.assertThat((request.getPath().equals(fileStoreTable.location().toString()) && request.getPartition().equals(partition) && request.getTable().equals(fileStoreTable.fullName()) && (params == null || params.equals(request.getParams())) ? 1 : 0) != 0).isTrue();
    }

    public static CoreOptions createCoreOptions() {
        HashMap<String, String> httpOptions = new HashMap<String, String>();
        httpOptions.put(CoreOptions.PARTITION_MARK_DONE_ACTION_URL.key(), server.getBaseUrl());
        if (params != null) {
            httpOptions.put(CoreOptions.PARTITION_MARK_DONE_ACTION_PARAMS.key(), params);
        }
        return new CoreOptions(httpOptions);
    }

    public FileStoreTable createFileStoreTable() throws Exception {
        Path tablePath = new Path(this.folder.newFolder().toURI().toString());
        Options options = new Options();
        options.set(CoreOptions.PATH, (Object)tablePath.toString());
        TableSchema tableSchema = SchemaUtils.forceCommit((SchemaManager)new SchemaManager((FileIO)LocalFileIO.create(), tablePath), (Schema)new Schema(InternalRowUtilsTest.ROW_TYPE.getFields(), Collections.emptyList(), Collections.emptyList(), options.toMap(), ""));
        return FileStoreTableFactory.create((FileIO)FileIOFinder.find((Path)tablePath), (Path)tablePath, (TableSchema)tableSchema, (Options)options, (CatalogEnvironment)CatalogEnvironment.empty());
    }

    static {
        params = "key1=value1,key2=value2";
    }
}

