/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.testutils.source.reader.TestingReaderContext;
import org.apache.flink.connector.testutils.source.reader.TestingReaderOutput;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.flink.source.FileStoreSourceReader;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializerTest;
import org.apache.paimon.flink.source.ReaderConsumeProgressEvent;
import org.apache.paimon.flink.source.TestChangelogDataReadWrite;
import org.apache.paimon.flink.source.metrics.FileStoreSourceReaderMetrics;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileStoreSourceReaderTest {
    @TempDir
    protected java.nio.file.Path tempDir;

    @BeforeEach
    public void beforeEach() throws Exception {
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), new Path(this.tempDir.toUri()));
        schemaManager.createTable(new Schema(new RowType(Arrays.asList(new DataField(0, "k", (DataType)new BigIntType()), new DataField(1, "v", (DataType)new BigIntType()), new DataField(2, "default", (DataType)new IntType()))).getFields(), Collections.singletonList("default"), Arrays.asList("k", "default"), Collections.emptyMap(), null));
    }

    @Test
    public void testRequestSplitWhenNoSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileStoreSourceReader reader = this.createReader(context);
        reader.start();
        reader.close();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(1);
    }

    @Test
    public void testNoSplitRequestWhenSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileStoreSourceReader reader = this.createReader(context);
        reader.addSplits(Collections.singletonList(FileStoreSourceReaderTest.createTestFileSplit("id1")));
        reader.start();
        reader.close();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(0);
    }

    @Test
    public void testAddMultipleSplits() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileStoreSourceReader reader = this.createReader(context);
        reader.start();
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(1);
        reader.addSplits(Arrays.asList(FileStoreSourceReaderTest.createTestFileSplit("id1"), FileStoreSourceReaderTest.createTestFileSplit("id2")));
        TestingReaderOutput output = new TestingReaderOutput();
        while (reader.getNumberOfCurrentlyAssignedSplits() > 0) {
            reader.pollNext((ReaderOutput)output);
            Thread.sleep(10L);
        }
        Assertions.assertThat((int)context.getNumSplitRequests()).isEqualTo(2);
    }

    @Test
    public void testReaderOnSplitFinished() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileStoreSourceReader reader = this.createReader(context);
        reader.start();
        reader.addSplits(Collections.singletonList(FileStoreSourceReaderTest.createTestFileSplit("id1")));
        TestingReaderOutput output = new TestingReaderOutput();
        while (reader.getNumberOfCurrentlyAssignedSplits() > 0) {
            reader.pollNext((ReaderOutput)output);
            Thread.sleep(10L);
        }
        List sourceEvents = context.getSentEvents();
        Assertions.assertThat((int)sourceEvents.size()).isEqualTo(1);
        Assertions.assertThat(sourceEvents.get(0)).isExactlyInstanceOf(ReaderConsumeProgressEvent.class);
        Assertions.assertThat((Object)((ReaderConsumeProgressEvent)sourceEvents.get(0))).matches(event -> event.lastConsumeSnapshotId() == 1L);
    }

    @Test
    public void testIOManagerIsSet() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        KeyValueTableRead tableRead = new TestChangelogDataReadWrite(this.tempDir.toString()).createReadWithKey();
        FileStoreSourceReader reader = this.createReader(context, (TableRead)tableRead);
        reader.addSplits(Collections.singletonList(FileStoreSourceReaderTest.createTestFileSplit("id1")));
        reader.start();
        reader.close();
        Assertions.assertThat((Object)tableRead.ioManager()).isNotNull();
    }

    protected FileStoreSourceReader createReader(TestingReaderContext context) {
        return this.createReader(context, (TableRead)new TestChangelogDataReadWrite(this.tempDir.toString()).createReadWithKey());
    }

    protected FileStoreSourceReader createReader(TestingReaderContext context, TableRead tableRead) {
        return new FileStoreSourceReader((SourceReaderContext)context, tableRead, new FileStoreSourceReaderMetrics((MetricGroup)new DummyMetricGroup()), IOManager.create((String)this.tempDir.toString()), null, null);
    }

    protected static FileStoreSourceSplit createTestFileSplit(String id) {
        return FileStoreSourceSplitSerializerTest.newSourceSplit(id, MergeTreeCompactManagerTest.row((int)1), 0, Collections.emptyList());
    }

    public static class DummyMetricGroup
    implements MetricGroup {
        public Counter counter(String name) {
            return null;
        }

        public <C extends Counter> C counter(String name, C counter) {
            return null;
        }

        public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
            return null;
        }

        public <H extends Histogram> H histogram(String name, H histogram) {
            return null;
        }

        public <M extends Meter> M meter(String name, M meter) {
            return null;
        }

        public MetricGroup addGroup(String name) {
            return null;
        }

        public MetricGroup addGroup(String key, String value) {
            return null;
        }

        public String[] getScopeComponents() {
            return new String[0];
        }

        public Map<String, String> getAllVariables() {
            return null;
        }

        public String getMetricIdentifier(String metricName) {
            return null;
        }

        public String getMetricIdentifier(String metricName, CharacterFilter filter) {
            return null;
        }
    }
}

