/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.nio.file.Path;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.source.FlinkSourceBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FlinkSourceBuilderTest {
    @TempDir
    Path tempDir;
    private Catalog catalog;

    @BeforeEach
    public void setUp() {
        try {
            this.initCatalog();
        }
        catch (Exception e) {
            throw new RuntimeException("Catalog initialization failed", e);
        }
    }

    private void initCatalog() throws Exception {
        if (this.catalog == null) {
            this.catalog = CatalogFactory.createCatalog((CatalogContext)CatalogContext.create((org.apache.paimon.fs.Path)new org.apache.paimon.fs.Path(this.tempDir.toUri())));
            this.catalog.createDatabase("default", false);
        }
    }

    private Table createTable(String tableName, boolean hasPrimaryKey, int bucketNum, boolean bucketAppendOrdered) throws Exception {
        Schema.Builder schemaBuilder = Schema.newBuilder().column("a", (DataType)DataTypes.INT()).option("bucket", bucketNum + "").option("bucket-append-ordered", String.valueOf(bucketAppendOrdered));
        if (hasPrimaryKey) {
            schemaBuilder.primaryKey(new String[]{"a"});
        }
        if (bucketNum != -1) {
            schemaBuilder.option("bucket-key", "a");
        }
        Schema schema = schemaBuilder.build();
        Identifier identifier = Identifier.create((String)"default", (String)tableName);
        this.catalog.createTable(identifier, schema, false);
        return this.catalog.getTable(identifier);
    }

    @Test
    public void testUnawareBucket() throws Exception {
        Table table = this.createTable("t1", true, 2, true);
        FlinkSourceBuilder builder = new FlinkSourceBuilder(table);
        Assertions.assertFalse((boolean)builder.isUnordered());
        table = this.createTable("t2", true, 2, false);
        builder = new FlinkSourceBuilder(table);
        Assertions.assertFalse((boolean)builder.isUnordered());
        table = this.createTable("t3", true, -1, false);
        builder = new FlinkSourceBuilder(table);
        Assertions.assertFalse((boolean)builder.isUnordered());
        table = this.createTable("t4", false, 2, true);
        builder = new FlinkSourceBuilder(table);
        Assertions.assertFalse((boolean)builder.isUnordered());
        table = this.createTable("t5", false, -1, true);
        builder = new FlinkSourceBuilder(table);
        Assertions.assertTrue((boolean)builder.isUnordered());
        table = this.createTable("t6", false, 2, false);
        builder = new FlinkSourceBuilder(table);
        Assertions.assertTrue((boolean)builder.isUnordered());
    }
}

