/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableTestBase;
import org.apache.paimon.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlinkTableSourceTest
extends TableTestBase {
    @Test
    public void testApplyFilterNonPartitionTable() throws Exception {
        LocalFileIO fileIO = LocalFileIO.create();
        Path tablePath = new Path(String.format("%s/%s.db/%s", this.warehouse, this.database, "T"));
        Schema schema = Schema.newBuilder().column("col1", (DataType)org.apache.paimon.types.DataTypes.INT()).build();
        TableSchema tableSchema = new SchemaManager((FileIO)fileIO, tablePath).createTable(schema);
        FileStoreTable table = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)tablePath, (TableSchema)tableSchema);
        DataTableSource tableSource = new DataTableSource(ObjectIdentifier.of((String)"catalog1", (String)"db1", (String)"T"), (Table)table, false, null, null);
        ImmutableList filters = ImmutableList.of((Object)this.col1Equal1());
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)filters);
    }

    @Test
    public void testApplyPartitionTable() throws Exception {
        LocalFileIO fileIO = LocalFileIO.create();
        Path tablePath = new Path(String.format("%s/%s.db/%s", this.warehouse, this.database, "T"));
        Schema schema = Schema.newBuilder().column("col1", (DataType)org.apache.paimon.types.DataTypes.INT()).column("col2", (DataType)org.apache.paimon.types.DataTypes.INT()).column("p1", (DataType)org.apache.paimon.types.DataTypes.INT()).column("p2", (DataType)org.apache.paimon.types.DataTypes.STRING()).partitionKeys(new String[]{"p1", "p2"}).build();
        TableSchema tableSchema = new SchemaManager((FileIO)fileIO, tablePath).createTable(schema);
        FileStoreTable table = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)tablePath, (TableSchema)tableSchema);
        DataTableSource tableSource = new DataTableSource(ObjectIdentifier.of((String)"catalog1", (String)"db1", (String)"T"), (Table)table, false, null, null);
        ImmutableList filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.p1Equal1());
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(0)));
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.p2Like("%a"));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)filters);
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.p2Like("a%"));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(0)));
        filters = ImmutableList.of((Object)this.rand());
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)filters);
        filters = ImmutableList.of((Object)this.upperP2EqualA());
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)filters);
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.or(this.p2Like("a%"), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(0)));
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.or(this.p2Like("%a"), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).containsExactlyInAnyOrder((Object[])filters.toArray(new ResolvedExpression[0]));
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.and(this.p2Like("a%"), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(0)));
        filters = ImmutableList.of((Object)this.col1Equal1(), (Object)this.and(this.p2Like("%a"), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).containsExactlyInAnyOrder((Object[])filters.toArray(new ResolvedExpression[0]));
        filters = ImmutableList.of((Object)this.p2Like("a%"), (Object)this.or(this.col1Equal1(), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(1)));
        filters = ImmutableList.of((Object)this.p2Like("a%"), (Object)this.and(this.col1Equal1(), this.p1Equal1()));
        Assertions.assertThat((List)tableSource.applyFilters((List)filters).getRemainingFilters()).isEqualTo((Object)ImmutableList.of(filters.get(1)));
    }

    private ResolvedExpression col1Equal1() {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (List)ImmutableList.of((Object)new FieldReferenceExpression("col1", DataTypes.INT(), 0, 0), (Object)new ValueLiteralExpression((Object)1, (org.apache.flink.table.types.DataType)DataTypes.INT().notNull())), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression p1Equal1() {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (List)ImmutableList.of((Object)new FieldReferenceExpression("p1", DataTypes.INT(), 0, 2), (Object)new ValueLiteralExpression((Object)1, (org.apache.flink.table.types.DataType)DataTypes.INT().notNull())), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression p2Like(String literal) {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (List)ImmutableList.of((Object)new FieldReferenceExpression("p2", DataTypes.STRING(), 0, 3), (Object)new ValueLiteralExpression((Object)literal, (org.apache.flink.table.types.DataType)DataTypes.STRING().notNull())), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression rand() {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (List)ImmutableList.of((Object)CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.RAND, (List)ImmutableList.of((Object)new ValueLiteralExpression((Object)42, (org.apache.flink.table.types.DataType)DataTypes.INT().notNull())), (org.apache.flink.table.types.DataType)((org.apache.flink.table.types.DataType)DataTypes.DOUBLE().notNull())), (Object)new ValueLiteralExpression((Object)0.1, (org.apache.flink.table.types.DataType)DataTypes.DOUBLE().notNull())), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression upperP2EqualA() {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (List)ImmutableList.of((Object)CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.UPPER, (List)ImmutableList.of((Object)new FieldReferenceExpression("p2", DataTypes.STRING(), 0, 3)), (org.apache.flink.table.types.DataType)((org.apache.flink.table.types.DataType)DataTypes.STRING().notNull())), (Object)new ValueLiteralExpression((Object)"A", (org.apache.flink.table.types.DataType)DataTypes.STRING().notNull())), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression or(ResolvedExpression e1, ResolvedExpression e2) {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.OR, (List)ImmutableList.of((Object)e1, (Object)e2), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }

    private ResolvedExpression and(ResolvedExpression e1, ResolvedExpression e2) {
        return CallExpression.anonymous((FunctionDefinition)BuiltInFunctionDefinitions.AND, (List)ImmutableList.of((Object)e1, (Object)e2), (org.apache.flink.table.types.DataType)DataTypes.BOOLEAN());
    }
}

