/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.types.Row;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.RESTCatalogITCaseBase;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SupportsDirectWrite;
import org.apache.paimon.format.parquet.ParquetFileFormatFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.ResolvingFileIO;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTToken;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormatTableReadITCaseBase
extends RESTCatalogITCaseBase {
    @Test
    public void testParquetFileFormat() throws IOException {
        ParquetFileFormatFactory formatFactory = new ParquetFileFormatFactory();
        RowType rowType = RowType.builder().field("a", (DataType)DataTypes.INT()).field("b", (DataType)DataTypes.INT()).field("c", (DataType)DataTypes.INT()).build();
        FormatWriterFactory factory = formatFactory.create(new FileFormatFactory.FormatContext(new Options(), 1024, 1024)).createWriterFactory(rowType);
        InternalRow[] datas = new InternalRow[]{GenericRow.of((Object[])new Object[]{1, 1, 1}), GenericRow.of((Object[])new Object[]{2, 2, 2})};
        String tableName = "format_table_test";
        this.sql("CREATE TABLE %s (a INT, b INT, c INT) WITH ('file.format'='parquet', 'type'='format-table')", tableName);
        this.write(factory, new Path(this.dataPath, String.format("default.db/%s/data-1.parquet", tableName)), datas);
        RESTToken expiredDataToken = new RESTToken((Map)ImmutableMap.of((Object)"akId", (Object)"akId-expire", (Object)"akSecret", (Object)UUID.randomUUID().toString()), System.currentTimeMillis() + 1000000L);
        Identifier identifier = Identifier.create((String)"default", (String)tableName);
        this.restCatalogServer.setDataToken(identifier, expiredDataToken);
        Assertions.assertThat(this.sql("SELECT a FROM %s", tableName)).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2})});
        this.sql("Drop TABLE %s", tableName);
    }

    protected void write(FormatWriterFactory factory, Path file, InternalRow ... rows) throws IOException {
        FormatWriter writer;
        ResolvingFileIO fileIO = new ResolvingFileIO();
        Options catalogOptions = new Options();
        catalogOptions.set(CatalogOptions.WAREHOUSE, (Object)this.dataPath);
        CatalogContext catalogContext = CatalogContext.create((Options)catalogOptions);
        fileIO.configure(catalogContext);
        PositionOutputStream out = null;
        if (factory instanceof SupportsDirectWrite) {
            writer = ((SupportsDirectWrite)factory).create((FileIO)fileIO, file, "zstd");
        } else {
            out = fileIO.newOutputStream(file, true);
            writer = factory.create(out, "zstd");
        }
        for (InternalRow row : rows) {
            writer.addElement(row);
        }
        writer.close();
        if (out != null) {
            out.close();
        }
    }
}

