/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.SnapshotTest;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.compact.DeduplicateMergeFunction;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;

public class TestChangelogDataReadWrite {
    private static final RowType KEY_TYPE = new RowType(Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType())));
    private static final RowType VALUE_TYPE = new RowType(Collections.singletonList(new DataField(1, "v", (DataType)new BigIntType())));
    private static final RowType PARTITION_TYPE = new RowType(Collections.singletonList(new DataField(0, "p", (DataType)new IntType())));
    private static final Comparator<InternalRow> COMPARATOR = Comparator.comparingLong(o -> o.getLong(0));
    private static final RecordEqualiser EQUALISER = (RecordEqualiser & Serializable)(row1, row2) -> row1.getLong(0) == row2.getLong(0);
    private static final KeyValueFieldsExtractor EXTRACTOR = new KeyValueFieldsExtractor(){

        public List<DataField> keyFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType(false)));
        }

        public List<DataField> valueFields(TableSchema schema) {
            return Collections.singletonList(new DataField(1, "v", (DataType)new BigIntType(false)));
        }
    };
    private final FileFormat avro = FileFormat.fromIdentifier((String)"avro", (Options)new Options());
    private final Path tablePath;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final String commitUser;

    public TestChangelogDataReadWrite(String root) {
        this.tablePath = new Path(root);
        this.pathFactory = new FileStorePathFactory(this.tablePath, RowType.of((DataType[])new DataType[]{new IntType()}), "default", ((String)CoreOptions.FILE_FORMAT.defaultValue()).toString(), (String)CoreOptions.DATA_FILE_PREFIX.defaultValue(), (String)CoreOptions.CHANGELOG_FILE_PREFIX.defaultValue(), ((Boolean)CoreOptions.PARTITION_GENERATE_LEGACY_NAME.defaultValue()).booleanValue(), ((Boolean)CoreOptions.FILE_SUFFIX_INCLUDE_COMPRESSION.defaultValue()).booleanValue(), (String)CoreOptions.FILE_COMPRESSION.defaultValue(), null, null, false);
        this.snapshotManager = SnapshotTest.newSnapshotManager((FileIO)LocalFileIO.create(), (Path)new Path(root));
        this.commitUser = UUID.randomUUID().toString();
    }

    public KeyValueTableRead createReadWithKey() {
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        CoreOptions options = new CoreOptions(new HashMap());
        TableSchema schema = schemaManager.schema(0L);
        MergeFileSplitRead read = new MergeFileSplitRead(options, schema, KEY_TYPE, VALUE_TYPE, COMPARATOR, DeduplicateMergeFunction.factory(), KeyValueFileReaderFactory.builder((FileIO)LocalFileIO.create(), (SchemaManager)schemaManager, (TableSchema)schema, (RowType)KEY_TYPE, (RowType)VALUE_TYPE, ignore -> this.avro, (FileStorePathFactory)this.pathFactory, (KeyValueFieldsExtractor)EXTRACTOR, (CoreOptions)options));
        RawFileSplitRead rawFileRead = new RawFileSplitRead((FileIO)LocalFileIO.create(), schemaManager, schema, VALUE_TYPE, FileFormatDiscover.of((CoreOptions)options), this.pathFactory, options.fileIndexReadEnabled(), false);
        return new KeyValueTableRead(() -> read, () -> rawFileRead, null);
    }

    public List<DataFileMeta> writeFiles(BinaryRow partition, int bucket, List<Tuple2<Long, Long>> kvs) throws Exception {
        RecordWriter<KeyValue> writer = this.createMergeTreeWriter(partition, bucket);
        for (Tuple2<Long, Long> tuple2 : kvs) {
            writer.write((Object)new KeyValue().replace((InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f0}), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f1})));
        }
        List files = writer.prepareCommit(true).newFilesIncrement().newFiles();
        writer.close();
        return new ArrayList<DataFileMeta>(files);
    }

    public RecordWriter<KeyValue> createMergeTreeWriter(BinaryRow partition, int bucket) {
        CoreOptions options = new CoreOptions(Collections.singletonMap(CoreOptions.FILE_FORMAT.key(), "avro"));
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        KeyValueFileStoreWrite write = new KeyValueFileStoreWrite((FileIO)LocalFileIO.create(), schemaManager, schemaManager.schema(0L), this.commitUser, PARTITION_TYPE, KEY_TYPE, VALUE_TYPE, () -> COMPARATOR, () -> null, () -> EQUALISER, DeduplicateMergeFunction.factory(), this.pathFactory, (coreOptions, format) -> this.pathFactory, this.snapshotManager, null, null, null, options, EXTRACTOR, this.tablePath.getName());
        write.withIgnorePreviousFiles(true);
        RecordWriter writer = write.createWriterContainer((BinaryRow)partition, (int)bucket).writer;
        ((MemoryOwner)writer).setMemoryPool((MemorySegmentPool)new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize()));
        return writer;
    }
}

