/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.statistics;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.flink.source.statistics.FileStoreTableStatisticsTestBase;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrimaryKeyTableStatisticsTest
extends FileStoreTableStatisticsTestBase {
    @Override
    @Test
    public void testTableFilterValueStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource keyFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.greaterThan(2, (Object)500L), (int[][])null, null, null, null, null);
        Assertions.assertThat((long)keyFilterSource.reportStatistics().getRowCount()).isEqualTo(9L);
    }

    @Override
    FileStoreTable createStoreTable() throws Exception {
        Options options = new Options();
        options.set(CoreOptions.PATH, (Object)this.tablePath.toString());
        options.set(CoreOptions.BUCKET, (Object)1);
        Schema.Builder builder = this.schemaBuilder();
        builder.options(options.toMap());
        TableSchema tableSchema = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath).createTable(builder.partitionKeys(new String[]{"pt"}).primaryKey(new String[]{"pt", "a"}).build());
        return FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)this.tablePath, (TableSchema)tableSchema);
    }
}

