/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MigrateDatabaseAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class MigrateDatabaseActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "migrate_database";
    private static final String SOURCE_TYPE = "source_type";
    private static final String OPTIONS = "options";
    private static final String PARALLELISM = "parallelism";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String connector = params.get(SOURCE_TYPE);
        String sourceHiveDatabase = params.get("database");
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        String tableConf = params.get(OPTIONS);
        Integer parallelism = Integer.parseInt(params.get(PARALLELISM));
        MigrateDatabaseAction migrateDatabaseAction = new MigrateDatabaseAction(connector, sourceHiveDatabase, catalogConfig, tableConf, parallelism);
        return Optional.of(migrateDatabaseAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"migrate_database\" migrate all tables in database from hive to paimon.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  migrate_database \\\n--warehouse <warehouse_path> \\\n--source_type hive \\\n--database <database_name> \\\n[--catalog_conf <key>=<value] \\\n[--options <key>=<value>,<key>=<value>,...]");
    }
}

