/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone.files;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.clone.files.CloneFileInfo;
import org.apache.paimon.flink.clone.files.CloneFilesProcessFunction;
import org.apache.paimon.flink.clone.schema.CloneSchemaInfo;
import org.apache.paimon.flink.predicate.SimpleSqlPredicateConvertor;
import org.apache.paimon.hive.clone.HiveCloneUtils;
import org.apache.paimon.hive.clone.HivePartitionFiles;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;

public class ListCloneFilesFunction
extends CloneFilesProcessFunction<CloneSchemaInfo, CloneFileInfo> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String whereSql;

    public ListCloneFilesFunction(Map<String, String> sourceCatalogConfig, Map<String, String> targetCatalogConfig, @Nullable String whereSql) {
        super(sourceCatalogConfig, targetCatalogConfig);
        this.whereSql = whereSql;
    }

    public void processElement(CloneSchemaInfo cloneSchemaInfo, ProcessFunction.Context context, Collector<CloneFileInfo> collector) throws Exception {
        Tuple2<Identifier, Identifier> tuple = cloneSchemaInfo.identifierTuple();
        FileStoreTable table = (FileStoreTable)this.targetCatalog.getTable((Identifier)tuple.f1);
        PartitionPredicate predicate = ListCloneFilesFunction.getPartitionPredicate(this.whereSql, table.schema().logicalPartitionType(), (Identifier)tuple.f0);
        try {
            List<HivePartitionFiles> allPartitions = HiveCloneUtils.listFiles(this.hiveCatalog, (Identifier)tuple.f0, table.schema().logicalPartitionType(), table.coreOptions().partitionDefaultName(), predicate);
            for (HivePartitionFiles partitionFiles : allPartitions) {
                CloneFileInfo.fromHive((Identifier)tuple.f1, partitionFiles).forEach(arg_0 -> collector.collect(arg_0));
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to list clone files for table " + ((Identifier)tuple.f0).getFullName(), e);
        }
    }

    @Nullable
    public static PartitionPredicate getPartitionPredicate(@Nullable String whereSql, RowType partitionType, Identifier tableId) throws Exception {
        if (whereSql == null) {
            return null;
        }
        SimpleSqlPredicateConvertor simpleSqlPredicateConvertor = new SimpleSqlPredicateConvertor(partitionType);
        try {
            Predicate predicate = simpleSqlPredicateConvertor.convertSqlToPredicate(whereSql);
            return PartitionPredicate.fromPredicate(partitionType, predicate);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse partition filter sql '" + whereSql + "' for table " + tableId.getFullName(), e);
        }
    }
}

