/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.append.AppendCompactTask;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.WriterRefresher;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.operation.metrics.MetricUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendTableCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(AppendTableCompactor.class);
    private FileStoreTable table;
    private BaseAppendFileStoreWrite write;
    private final String commitUser;
    protected final Queue<Future<CommitMessage>> result;
    private final Supplier<ExecutorService> compactExecutorsupplier;
    @Nullable
    private final CompactionMetrics compactionMetrics;
    @Nullable
    private final CompactionMetrics.Reporter metricsReporter;
    @Nullable
    protected final WriterRefresher writeRefresher;

    public AppendTableCompactor(FileStoreTable table, String commitUser, Supplier<ExecutorService> lazyCompactExecutor, @Nullable MetricGroup metricGroup, boolean isStreaming) {
        this.table = table;
        this.commitUser = commitUser;
        CoreOptions coreOptions = table.coreOptions();
        this.write = (BaseAppendFileStoreWrite)table.store().newWrite(commitUser);
        if (coreOptions.rowTrackingEnabled()) {
            this.write.withWriteType(SpecialFields.rowTypeWithRowTracking(table.rowType()));
        }
        this.result = new LinkedList<Future<CommitMessage>>();
        this.compactExecutorsupplier = lazyCompactExecutor;
        this.compactionMetrics = metricGroup == null ? null : new CompactionMetrics(new FlinkMetricRegistry(metricGroup), table.name());
        this.metricsReporter = this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(BinaryRow.EMPTY_ROW, 0);
        this.writeRefresher = WriterRefresher.create(isStreaming, table, this::replace);
    }

    public void processElement(AppendCompactTask task) throws Exception {
        this.result.add(this.compactExecutorsupplier.get().submit(() -> {
            MetricUtils.safeCall(this::startTimer, LOG);
            try {
                long startMillis = System.currentTimeMillis();
                CommitMessage commitMessage = task.doCompact(this.table, this.write);
                MetricUtils.safeCall(() -> {
                    if (this.metricsReporter != null) {
                        this.metricsReporter.reportCompactionTime(System.currentTimeMillis() - startMillis);
                        this.metricsReporter.increaseCompactionsCompletedCount();
                    }
                }, LOG);
                CommitMessage commitMessage2 = commitMessage;
                return commitMessage2;
            }
            finally {
                MetricUtils.safeCall(this::stopTimer, LOG);
                MetricUtils.safeCall(this::decreaseCompactionsQueuedCount, LOG);
            }
        }));
        this.recordCompactionsQueuedRequest();
    }

    private void recordCompactionsQueuedRequest() {
        if (this.metricsReporter != null) {
            this.metricsReporter.increaseCompactionsQueuedCount();
            this.metricsReporter.increaseCompactionsTotalCount();
        }
    }

    private void decreaseCompactionsQueuedCount() {
        if (this.metricsReporter != null) {
            this.metricsReporter.decreaseCompactionsQueuedCount();
        }
    }

    private void startTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().start();
        }
    }

    private void stopTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().finish();
        }
    }

    public void close() throws Exception {
        this.shutdown();
        if (this.metricsReporter != null) {
            MetricUtils.safeCall(this.metricsReporter::unregister, LOG);
        }
        if (this.compactionMetrics != null) {
            MetricUtils.safeCall(this.compactionMetrics::close, LOG);
        }
    }

    @VisibleForTesting
    void shutdown() throws Exception {
        Future resultFuture;
        ArrayList<CommitMessage> messages = new ArrayList<CommitMessage>();
        Iterator iterator = this.result.iterator();
        while (iterator.hasNext() && (resultFuture = (Future)iterator.next()).isDone()) {
            try {
                messages.add((CommitMessage)resultFuture.get());
            }
            catch (Exception exception) {}
        }
        if (messages.isEmpty()) {
            return;
        }
        try (TableCommitImpl tableCommit = this.table.newCommit(this.commitUser);){
            tableCommit.abort(messages);
        }
    }

    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<CommitMessage> tempList = new ArrayList<CommitMessage>();
        try {
            Future<CommitMessage> future;
            while (!this.result.isEmpty() && ((future = this.result.peek()).isDone() || waitCompaction)) {
                this.result.poll();
                tempList.add(future.get());
            }
            return tempList.stream().map(s -> new Committable(checkpointId, Committable.Kind.FILE, s)).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting tasks done.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an error while do compaction", e);
        }
    }

    public Iterable<Future<CommitMessage>> result() {
        return this.result;
    }

    private void replace(FileStoreTable newTable) throws Exception {
        this.table = newTable;
        Object states = this.write.checkpoint();
        this.write.close();
        this.write = (BaseAppendFileStoreWrite)newTable.store().newWrite(this.commitUser);
        this.write.restore(states);
    }

    public void tryRefreshWrite() {
        if (this.commitUser == null) {
            return;
        }
        if (this.writeRefresher != null) {
            this.writeRefresher.tryRefresh();
        }
    }
}

