/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.lookup.DynamicPartitionLoader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPartitionLevelLoader
extends DynamicPartitionLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionLevelLoader.class);
    private static final long serialVersionUID = 1L;
    private final int maxPartitionLoadLevel;
    private final List<InternalRow.FieldGetter> fieldGetters;
    private final String defaultPartitionName;

    DynamicPartitionLevelLoader(FileStoreTable table, Duration refreshInterval, Map<String, String> partitionLoadConfig) {
        super(table, refreshInterval);
        this.maxPartitionLoadLevel = this.getMaxPartitionLoadLevel(partitionLoadConfig, table.partitionKeys());
        this.fieldGetters = this.createPartitionFieldGetters();
        this.defaultPartitionName = table.coreOptions().partitionDefaultName();
        LOG.info("Init DynamicPartitionLevelLoader(table={}),maxPartitionLoadLevel is {}", (Object)table.name(), (Object)this.maxPartitionLoadLevel);
    }

    @Override
    protected List<BinaryRow> getMaxPartitions() {
        List<BinaryRow> newPartitions = this.table.newReadBuilder().newScan().listPartitions().stream().sorted(this.comparator.reversed()).collect(Collectors.toList());
        if (this.maxPartitionLoadLevel == this.table.partitionKeys().size() - 1) {
            if (newPartitions.size() <= 1) {
                return newPartitions;
            }
            return newPartitions.subList(0, 1);
        }
        newPartitions = this.extractMaxPartitionsForFixedLevel(newPartitions, this.maxPartitionLoadLevel);
        if (LOG.isDebugEnabled()) {
            LOG.debug("DynamicPartitionLevelLoader(currentPartitionLoadLevel={},table={}) finds new partitions: {}.", new Object[]{this.maxPartitionLoadLevel, this.table.name(), this.partitionsToString(newPartitions)});
        }
        return newPartitions;
    }

    private int getMaxPartitionLoadLevel(Map<String, String> toLoad, List<String> fields) {
        int i;
        Preconditions.checkArgument(toLoad.size() <= fields.size());
        int maxLoadLevel = fields.size() - 1;
        for (i = 0; i < fields.size(); ++i) {
            if (toLoad.containsKey(fields.get(i))) continue;
            maxLoadLevel = i - 1;
            break;
        }
        Preconditions.checkArgument(maxLoadLevel >= 0, "the top level partition must set load config.");
        for (i = maxLoadLevel + 1; i < fields.size(); ++i) {
            Preconditions.checkArgument(!toLoad.containsKey(fields.get(i)), "Max load level is %s, but partition field %s with a higher level %s sets MAX_PT.", maxLoadLevel, fields.get(i), i);
        }
        return maxLoadLevel;
    }

    private List<InternalRow.FieldGetter> createPartitionFieldGetters() {
        ArrayList<InternalRow.FieldGetter> fieldGetters = new ArrayList<InternalRow.FieldGetter>();
        RowType partitionType = this.table.rowType().project(this.table.partitionKeys());
        for (int i = 0; i < this.maxPartitionLoadLevel + 1; ++i) {
            fieldGetters.add(InternalRow.createFieldGetter(partitionType.getTypeAt(i), i));
        }
        return fieldGetters;
    }

    private List<BinaryRow> extractMaxPartitionsForFixedLevel(List<BinaryRow> partitions, int level) {
        int currentDistinct = 0;
        Object[] lastFields = new Object[level + 1];
        for (int i = 0; i < partitions.size(); ++i) {
            BinaryRow partition = partitions.get(i);
            Object[] newFields = new Object[level + 1];
            for (int j = 0; j <= level; ++j) {
                newFields[j] = this.fieldGetters.get(j).getFieldOrNull(partition);
                if (newFields[j] != null) continue;
                newFields[j] = this.defaultPartitionName;
            }
            if (Arrays.equals(newFields, lastFields)) continue;
            lastFields = newFields;
            if (++currentDistinct <= 1) continue;
            return partitions.subList(0, i);
        }
        return partitions;
    }
}

