/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Map;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.action.CompactActionFactory;
import org.apache.paimon.flink.action.CompactDatabaseAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TimeUtils;

public class CompactDatabaseProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "compact_database";

    @ProcedureHint(argument={@ArgumentHint(name="including_databases", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="mode", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="including_tables", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="excluding_tables", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="table_options", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="partition_idle_time", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="compact_strategy", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String includingDatabases, String mode, String includingTables, String excludingTables, String tableOptions, String partitionIdleTime, String compactStrategy) throws Exception {
        partitionIdleTime = this.notnull(partitionIdleTime);
        Map<String, String> catalogOptions = this.catalog.options();
        CompactDatabaseAction action = new CompactDatabaseAction(catalogOptions).includingDatabases(this.nullable(includingDatabases)).includingTables(this.nullable(includingTables)).excludingTables(this.nullable(excludingTables)).withDatabaseCompactMode(this.nullable(mode));
        if (!StringUtils.isNullOrWhitespaceOnly(tableOptions)) {
            action.withTableOptions(ParameterUtils.parseCommaSeparatedKeyValues(tableOptions));
        }
        if (!StringUtils.isNullOrWhitespaceOnly(partitionIdleTime)) {
            action.withPartitionIdleTime(TimeUtils.parseDuration(partitionIdleTime));
        }
        if (CompactActionFactory.checkCompactStrategy(compactStrategy)) {
            action.withFullCompaction(compactStrategy.trim().equalsIgnoreCase("full"));
        }
        return this.execute(procedureContext, action, "Compact database job");
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

