/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.TimeZone;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireChangelogImpl;
import org.apache.paimon.utils.DateTimeUtils;

public class ExpireChangelogsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_changelogs";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="retain_max", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="retain_min", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="max_deletes", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="delete_all", type=@DataTypeHint(value="BOOLEAN"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, Integer retainMax, Integer retainMin, String olderThanStr, Integer maxDeletes, Boolean deleteAll) throws Catalog.TableNotExistException {
        ExpireChangelogImpl expireChangelogs = (ExpireChangelogImpl)this.table(tableId).newExpireChangelog();
        ExpireConfig.Builder builder = ExpireConfig.builder();
        if (retainMax != null) {
            builder.changelogRetainMax(retainMax);
        }
        if (retainMin != null) {
            builder.changelogRetainMin(retainMin);
        }
        if (olderThanStr != null) {
            builder.changelogTimeRetain(Duration.ofMillis(System.currentTimeMillis() - DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).getMillisecond()));
        }
        if (maxDeletes != null) {
            builder.changelogMaxDeletes(maxDeletes);
        }
        if (deleteAll != null && deleteAll.booleanValue()) {
            expireChangelogs.expireAll();
            return new String[]{"Delete all separated changelogs success."};
        }
        return new String[]{expireChangelogs.config(builder.build()).expire() + ""};
    }
}

