/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.FileStore;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProcedureUtils;

public class ExpirePartitionsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_partitions";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="expiration_time", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="timestamp_formatter", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="timestamp_pattern", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="expire_strategy", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="max_expires", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true)})
    @DataTypeHint(value="ROW< expired_partitions STRING>")
    public Row[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy, Integer maxExpires, String options) throws Catalog.TableNotExistException {
        Row[] rowArray;
        Map<String, String> dynamicOptions = ProcedureUtils.fillInPartitionOptions(expireStrategy, timestampFormatter, timestampPattern, expirationTime, maxExpires, options);
        Table table = this.table(tableId).copy(dynamicOptions);
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        FileStore<?> fileStore = fileStoreTable.store();
        PartitionExpire partitionExpire = fileStore.newPartitionExpire("", fileStoreTable);
        Preconditions.checkNotNull(partitionExpire, "Both the partition expiration time and partition field can not be null.");
        List<Map<String, String>> expired = partitionExpire.expire(Long.MAX_VALUE);
        if (expired == null || expired.isEmpty()) {
            Row[] rowArray2 = new Row[1];
            rowArray = rowArray2;
            rowArray2[0] = Row.of((Object[])new Object[]{"No expired partitions."});
        } else {
            rowArray = (Row[])expired.stream().map(x -> {
                String r = x.toString();
                return Row.of((Object[])new Object[]{r.substring(1, r.length() - 1)});
            }).toArray(Row[]::new);
        }
        return rowArray;
    }
}

