/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.HashMap;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.ProcedureUtils;

public class ExpireSnapshotsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_snapshots";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=false), @ArgumentHint(name="retain_max", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="retain_min", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="max_deletes", type=@DataTypeHint(value="INTEGER"), isOptional=true), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, Integer retainMax, Integer retainMin, String olderThanStr, Integer maxDeletes, String options) throws Catalog.TableNotExistException {
        Table table = this.table(tableId);
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        ProcedureUtils.putAllOptions(dynamicOptions, options);
        table = table.copy(dynamicOptions);
        ExpireSnapshots expireSnapshots = table.newExpireSnapshots();
        CoreOptions tableOptions = ((FileStoreTable)table).store().options();
        ExpireConfig.Builder builder = ProcedureUtils.fillInSnapshotOptions(tableOptions, retainMax, retainMin, olderThanStr, maxDeletes);
        return new String[]{expireSnapshots.config(builder.build()).expire() + ""};
    }
}

