/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.RescaleAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.ParameterUtils;

public class RescaleProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "rescale";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="bucket_num", type=@DataTypeHint(value="INT"), isOptional=true), @ArgumentHint(name="partition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="scan_parallelism", type=@DataTypeHint(value="INT"), isOptional=true), @ArgumentHint(name="sink_parallelism", type=@DataTypeHint(value="INT"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, @Nullable Integer bucketNum, @Nullable String partition, @Nullable Integer scanParallelism, @Nullable Integer sinkParallelism) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        RescaleAction action = new RescaleAction(databaseName, tableName, this.catalog.options());
        if (bucketNum != null) {
            action.withBucketNum(bucketNum);
        }
        if (partition != null) {
            action.withPartition(ParameterUtils.getPartitions(partition).get(0));
        }
        if (scanParallelism != null) {
            action.withScanParallelism(scanParallelism);
        }
        if (sinkParallelism != null) {
            action.withSinkParallelism(sinkParallelism);
        }
        return this.execute(procedureContext, action, "Rescale Postpone Bucket : " + identifier.getFullName());
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

