/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Objects;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.table.sink.ChannelComputer;

public class MultiTableCommittableChannelComputer
implements ChannelComputer<MultiTableCommittable> {
    private static final long serialVersionUID = 1L;
    private transient int numChannels;

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
    }

    @Override
    public int channel(MultiTableCommittable multiTableCommittable) {
        return MultiTableCommittableChannelComputer.computeChannel(multiTableCommittable.getDatabase(), multiTableCommittable.getTable(), this.numChannels);
    }

    public static int computeChannel(String database, String table, int numChannels) {
        return Math.floorMod(Objects.hash(database, table), numChannels);
    }

    public String toString() {
        return "shuffle by table";
    }
}

