/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.GlobalFullCompactionSinkWrite;
import org.apache.paimon.flink.sink.LookupSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.sink.StoreSinkWriteState;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.operation.WriteRestore;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializableRunnable;

public interface StoreSinkWrite {
    public void setWriteRestore(WriteRestore var1);

    @Nullable
    public SinkRecord write(InternalRow var1) throws Exception;

    @Nullable
    public SinkRecord write(InternalRow var1, int var2) throws Exception;

    public SinkRecord toLogRecord(SinkRecord var1);

    public void compact(BinaryRow var1, int var2, boolean var3) throws Exception;

    public void notifyNewFiles(long var1, BinaryRow var3, int var4, List<DataFileMeta> var5);

    public List<Committable> prepareCommit(boolean var1, long var2) throws IOException;

    public void snapshotState() throws Exception;

    public boolean streamingMode();

    public void close() throws Exception;

    public void replace(FileStoreTable var1) throws Exception;

    public static Provider createWriteProvider(FileStoreTable fileStoreTable, CheckpointConfig checkpointConfig, boolean isStreaming, boolean ignorePreviousFiles, boolean hasSinkMaterializer) {
        boolean waitCompaction;
        SerializableRunnable assertNoSinkMaterializer = () -> Preconditions.checkArgument(!hasSinkMaterializer, String.format("Sink materializer must not be used with Paimon sink. Please set '%s' to '%s' in Flink's config.", ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE.key(), ExecutionConfigOptions.UpsertMaterialize.NONE.name()));
        Options options = fileStoreTable.coreOptions().toConfiguration();
        CoreOptions.ChangelogProducer changelogProducer = fileStoreTable.coreOptions().changelogProducer();
        CoreOptions coreOptions = fileStoreTable.coreOptions();
        if (coreOptions.writeOnly()) {
            waitCompaction = false;
        } else {
            waitCompaction = coreOptions.prepareCommitWaitCompaction();
            int deltaCommits = -1;
            if (options.contains(CoreOptions.FULL_COMPACTION_DELTA_COMMITS)) {
                deltaCommits = options.get(CoreOptions.FULL_COMPACTION_DELTA_COMMITS);
            } else if (options.contains(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL)) {
                long fullCompactionThresholdMs = options.get(FlinkConnectorOptions.CHANGELOG_PRODUCER_FULL_COMPACTION_TRIGGER_INTERVAL).toMillis();
                deltaCommits = (int)(fullCompactionThresholdMs / checkpointConfig.getCheckpointInterval());
            }
            if (changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION || deltaCommits >= 0) {
                int finalDeltaCommits = Math.max(deltaCommits, 1);
                return (table, commitUser, state, ioManager, memoryPoolFactory, metricGroup) -> {
                    assertNoSinkMaterializer.run();
                    return new GlobalFullCompactionSinkWrite(table, commitUser, state, ioManager, ignorePreviousFiles, waitCompaction, finalDeltaCommits, isStreaming, memoryPoolFactory, metricGroup);
                };
            }
            if (coreOptions.needLookup()) {
                return (table, commitUser, state, ioManager, memoryPoolFactory, metricGroup) -> {
                    assertNoSinkMaterializer.run();
                    return new LookupSinkWrite(table, commitUser, state, ioManager, ignorePreviousFiles, waitCompaction, isStreaming, memoryPoolFactory, metricGroup);
                };
            }
        }
        return (table, commitUser, state, ioManager, memoryPoolFactory, metricGroup) -> {
            assertNoSinkMaterializer.run();
            return new StoreSinkWriteImpl(table, commitUser, state, ioManager, ignorePreviousFiles, waitCompaction, isStreaming, memoryPoolFactory, metricGroup);
        };
    }

    @FunctionalInterface
    public static interface Provider
    extends Serializable {
        public StoreSinkWrite provide(FileStoreTable var1, String var2, StoreSinkWriteState var3, IOManager var4, MemoryPoolFactory var5, @Nullable MetricGroup var6);
    }
}

