/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableFilter
implements Serializable {
    private String dbName;
    private List<String> tableWhitelist;
    private List<String> tablePrefixes;
    private List<String> tableSuffixes;
    private String tblIncludingPattern = ".*";
    private String tblExcludingPattern = "";

    public TableFilter(String dbName, List<String> tableWhitelist, List<String> tablePrefixes, List<String> tableSuffixes, String tblIncludingPattern, String tblExcludingPattern) {
        this.dbName = dbName;
        this.tableWhitelist = tableWhitelist;
        this.tablePrefixes = tablePrefixes;
        this.tableSuffixes = tableSuffixes;
        this.tblIncludingPattern = tblIncludingPattern;
        this.tblExcludingPattern = tblExcludingPattern;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public List<String> getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setTableWhitelist(List<String> tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public List<String> getTablePrefixes() {
        return this.tablePrefixes;
    }

    public void setTablePrefixes(List<String> tablePrefixes) {
        this.tablePrefixes = tablePrefixes;
    }

    public List<String> getTableSuffixes() {
        return this.tableSuffixes;
    }

    public void setTableSuffixes(List<String> tableSuffixes) {
        this.tableSuffixes = tableSuffixes;
    }

    public String getTblIncludingPattern() {
        return this.tblIncludingPattern;
    }

    public void setTblIncludingPattern(String tblIncludingPattern) {
        this.tblIncludingPattern = tblIncludingPattern;
    }

    public String getTblExcludingPattern() {
        return this.tblExcludingPattern;
    }

    public void setTblExcludingPattern(String tblExcludingPattern) {
        this.tblExcludingPattern = tblExcludingPattern;
    }

    public List<String> filterTables(List<String> allTables) {
        List<String> inPatternList = Arrays.asList(this.tblIncludingPattern.split("\\|"));
        List exPatternList = this.tblExcludingPattern == null || this.tblExcludingPattern.isEmpty() ? Collections.emptyList() : Arrays.asList(this.tblExcludingPattern.split("\\|"));
        String inPattern = inPatternList.stream().flatMap(p -> this.tablePrefixes.isEmpty() ? Stream.of(p) : this.tablePrefixes.stream().map(prefix -> prefix + p)).flatMap(p -> this.tableSuffixes.isEmpty() ? Stream.of(p) : this.tableSuffixes.stream().map(suffix -> p + suffix)).collect(Collectors.joining("|"));
        String exPattern = exPatternList.isEmpty() ? "" : exPatternList.stream().flatMap(p -> this.tablePrefixes.isEmpty() ? Stream.of(p) : this.tablePrefixes.stream().map(prefix -> prefix + p)).flatMap(p -> this.tableSuffixes.isEmpty() ? Stream.of(p) : this.tableSuffixes.stream().map(suffix -> p + suffix)).collect(Collectors.joining("|"));
        return allTables.stream().filter(t -> exPattern.isEmpty() || !t.matches(exPattern)).filter(t -> this.tableWhitelist.contains(t) || t.matches(inPattern)).collect(Collectors.toList());
    }
}

