/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableScan;

public class FileStoreSourceSplitGenerator {
    private final String uuid = UUID.randomUUID().toString();
    private final AtomicInteger idCounter = new AtomicInteger(1);

    public List<FileStoreSourceSplit> createSplits(TableScan.Plan plan) {
        return plan.splits().stream().map(s -> new FileStoreSourceSplit(this.getNextId(), (Split)s)).collect(Collectors.toList());
    }

    protected final String getNextId() {
        return this.uuid + "-" + this.idCounter.getAndIncrement();
    }
}

