/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableSet;

public class FlinkCatalogPropertiesUtil {
    public static final String SCHEMA = "schema";
    private static final Pattern SCHEMA_COLUMN_NAME_SUFFIX = Pattern.compile("\\d+\\.name");
    private static final Pattern SCHEMA_COLUMN_METADATA_SUFFIX = Pattern.compile("\\d+\\.metadata");
    private static final Pattern SCHEMA_COLUMN_EXPR_SUFFIX = Pattern.compile("\\d+\\.expr");
    private static final Pattern SCHEMA_COLUMN_DATATYPE_SUFFIX = Pattern.compile("\\d+\\.data-type");
    private static final Pattern SCHEMA_COLUMN_VIRTUAL_SUFFIX = Pattern.compile("\\d+\\.virtual");
    private static final Set<Pattern> NON_PHYSICAL_KEY_PATTERNS = ImmutableSet.of(SCHEMA_COLUMN_NAME_SUFFIX, SCHEMA_COLUMN_METADATA_SUFFIX, SCHEMA_COLUMN_EXPR_SUFFIX, SCHEMA_COLUMN_DATATYPE_SUFFIX, SCHEMA_COLUMN_VIRTUAL_SUFFIX);

    public static Map<String, String> serializeNonPhysicalNewColumns(ResolvedSchema schema) {
        List nonPhysicalColumns = schema.getColumns().stream().filter(k -> !k.isPhysical()).collect(Collectors.toList());
        HashMap<String, String> serialized = new HashMap<String, String>();
        List columnNames = schema.getColumnNames();
        for (Column c : nonPhysicalColumns) {
            int index = columnNames.indexOf(c.getName());
            serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "name"), c.getName());
            serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "data-type"), c.getDataType().getLogicalType().asSerializableString());
            if (c instanceof Column.ComputedColumn) {
                Column.ComputedColumn computedColumn = (Column.ComputedColumn)c;
                serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "expr"), computedColumn.getExpression().asSerializableString());
                if (!computedColumn.getComment().isPresent()) continue;
                serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "comment"), (String)computedColumn.getComment().get());
                continue;
            }
            Column.MetadataColumn metadataColumn = (Column.MetadataColumn)c;
            serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "metadata"), metadataColumn.getMetadataKey().orElse(metadataColumn.getName()));
            serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "virtual"), Boolean.toString(metadataColumn.isVirtual()));
            if (!metadataColumn.getComment().isPresent()) continue;
            serialized.put(FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "comment"), (String)metadataColumn.getComment().get());
        }
        return serialized;
    }

    public static Map<String, String> serializeNewWatermarkSpec(WatermarkSpec watermarkSpec) {
        HashMap<String, String> serializedWatermarkSpec = new HashMap<String, String>();
        String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, "watermark", 0);
        serializedWatermarkSpec.put(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "rowtime"), watermarkSpec.getRowtimeAttribute());
        serializedWatermarkSpec.put(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.expr"), watermarkSpec.getWatermarkExpression().asSerializableString());
        serializedWatermarkSpec.put(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.data-type"), watermarkSpec.getWatermarkExpression().getOutputDataType().getLogicalType().asSerializableString());
        return serializedWatermarkSpec;
    }

    public static int nonPhysicalColumnsCount(Map<String, String> tableOptions, List<String> physicalColumns) {
        int count = 0;
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            if (!FlinkCatalogPropertiesUtil.isColumnNameKey(entry.getKey()) || physicalColumns.contains(entry.getValue())) continue;
            ++count;
        }
        return count;
    }

    public static boolean isNonPhysicalColumnKey(String key) {
        if (!key.startsWith(SCHEMA)) {
            return false;
        }
        String suffix = key.substring(SCHEMA.length() + 1);
        for (Pattern pattern : NON_PHYSICAL_KEY_PATTERNS) {
            if (!pattern.matcher(suffix).matches()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Integer> nonPhysicalColumns(Map<String, String> tableOptions, List<String> physicalColumns) {
        HashMap<String, Integer> nonPhysicalColumnIndex = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : tableOptions.entrySet()) {
            if (!FlinkCatalogPropertiesUtil.isColumnNameKey(entry.getKey()) || physicalColumns.contains(entry.getValue())) continue;
            String key = entry.getKey();
            int index = Integer.parseInt(key.substring(SCHEMA.length() + 1, key.indexOf(".", SCHEMA.length() + 1)));
            nonPhysicalColumnIndex.put(entry.getValue(), index);
        }
        return nonPhysicalColumnIndex;
    }

    private static boolean isColumnNameKey(String key) {
        return key.startsWith(SCHEMA) && SCHEMA_COLUMN_NAME_SUFFIX.matcher(key.substring(SCHEMA.length() + 1)).matches();
    }

    public static void deserializeNonPhysicalColumn(Map<String, String> options, int index, Schema.Builder builder) {
        String nameKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "name");
        String dataTypeKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "data-type");
        String exprKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "expr");
        String metadataKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "metadata");
        String virtualKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, index, "virtual");
        String name = options.get(nameKey);
        if (options.containsKey(exprKey)) {
            String expr = options.get(exprKey);
            builder.columnByExpression(name, expr);
        } else if (options.containsKey(metadataKey)) {
            String metadataAlias = options.get(metadataKey);
            boolean isVirtual = Boolean.parseBoolean(options.get(virtualKey));
            DataType dataType = TypeConversions.fromLogicalToDataType((LogicalType)LogicalTypeParser.parse((String)options.get(dataTypeKey), (ClassLoader)Thread.currentThread().getContextClassLoader()));
            if (metadataAlias.equals(name)) {
                builder.columnByMetadata(name, (AbstractDataType)dataType, isVirtual);
            } else {
                builder.columnByMetadata(name, (AbstractDataType)dataType, metadataAlias, isVirtual);
            }
        } else {
            throw new RuntimeException(String.format("Failed to build non-physical column. Current index is %s, options are %s", index, options));
        }
    }

    public static void deserializeWatermarkSpec(Map<String, String> options, Schema.Builder builder) {
        String watermarkPrefixKey = FlinkCatalogPropertiesUtil.compoundKey(SCHEMA, "watermark");
        String rowtimeKey = FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefixKey, 0, "rowtime");
        String exprKey = FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefixKey, 0, "strategy.expr");
        String rowtimeAttribute = options.get(rowtimeKey);
        String watermarkExpressionString = options.get(exprKey);
        builder.watermark(rowtimeAttribute, watermarkExpressionString);
    }

    public static String compoundKey(Object ... components) {
        return Stream.of(components).map(Object::toString).collect(Collectors.joining("."));
    }
}

