/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;

public class TableScanUtils {
    public static void streamingReadingValidate(Table table) {
        CoreOptions coreOptions = CoreOptions.fromMap(table.options());
        CoreOptions.MergeEngine mergeEngine = coreOptions.mergeEngine();
        HashMap<CoreOptions.MergeEngine, String> mergeEngineDesc = new HashMap<CoreOptions.MergeEngine, String>(){
            {
                this.put(CoreOptions.MergeEngine.PARTIAL_UPDATE, "Partial update");
                this.put(CoreOptions.MergeEngine.AGGREGATE, "Pre-aggregate");
                this.put(CoreOptions.MergeEngine.FIRST_ROW, "First row");
            }
        };
        if (table.primaryKeys().size() > 0 && mergeEngineDesc.containsKey(mergeEngine) && coreOptions.changelogProducer() == CoreOptions.ChangelogProducer.NONE) {
            throw new RuntimeException((String)mergeEngineDesc.get(mergeEngine) + " streaming reading is not supported. You can use 'lookup' or 'full-compaction' changelog producer to support streaming reading. ('input' changelog producer is also supported, but only returns input records.)");
        }
        Options options = Options.fromMap(table.options());
        if (options.get(FlinkConnectorOptions.SCAN_DEDICATED_SPLIT_GENERATION).booleanValue()) {
            throw new RuntimeException("The option " + FlinkConnectorOptions.SCAN_DEDICATED_SPLIT_GENERATION.key() + " can only used in batch mode.");
        }
    }

    public static Optional<Long> getSnapshotId(FileStoreSourceSplit split) {
        if (split.split() instanceof DataSplit) {
            return Optional.of(((DataSplit)split.split()).snapshotId());
        }
        return Optional.empty();
    }

    public static boolean supportCompactDiffStreamingReading(Table table) {
        CoreOptions options = CoreOptions.fromMap(table.options());
        HashSet<CoreOptions.MergeEngine> compactDiffReadingEngine = new HashSet<CoreOptions.MergeEngine>(){
            {
                this.add(CoreOptions.MergeEngine.PARTIAL_UPDATE);
                this.add(CoreOptions.MergeEngine.AGGREGATE);
            }
        };
        return options.needLookup() && compactDiffReadingEngine.contains(options.mergeEngine()) && Options.fromMap(options.toMap()).get(CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_DELETE) == false;
    }
}

