/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.json;

import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;

public class JsonOptions {
    public static final ConfigOption<Boolean> JSON_IGNORE_PARSE_ERRORS = ConfigOptions.key("json.ignore-parse-errors").booleanType().defaultValue(false).withDescription("Whether to ignore parse errors for JSON format");
    public static final ConfigOption<MapNullKeyMode> JSON_MAP_NULL_KEY_MODE = ConfigOptions.key("json.map-null-key-mode").enumType(MapNullKeyMode.class).defaultValue(MapNullKeyMode.FAIL).withDescription("How to handle map keys that are null.");
    public static final ConfigOption<String> JSON_MAP_NULL_KEY_LITERAL = ConfigOptions.key("json.map-null-key-literal").stringType().defaultValue("null").withDescription("Literal to use for null map keys when map-null-key-mode is LITERAL");
    public static final ConfigOption<String> LINE_DELIMITER = ConfigOptions.key("json.line-delimiter").stringType().defaultValue("\n").withDescription("The line delimiter for JSON format");
    private final boolean ignoreParseErrors;
    private final MapNullKeyMode mapNullKeyMode;
    private final String mapNullKeyLiteral;
    private final String lineDelimiter;

    public JsonOptions(Options options) {
        this.ignoreParseErrors = options.get(JSON_IGNORE_PARSE_ERRORS);
        this.mapNullKeyMode = options.get(JSON_MAP_NULL_KEY_MODE);
        this.mapNullKeyLiteral = options.get(JSON_MAP_NULL_KEY_LITERAL);
        this.lineDelimiter = options.get(LINE_DELIMITER);
    }

    public boolean ignoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public MapNullKeyMode getMapNullKeyMode() {
        return this.mapNullKeyMode;
    }

    public String getMapNullKeyLiteral() {
        return this.mapNullKeyLiteral;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public static enum MapNullKeyMode implements DescribedEnum
    {
        FAIL("fail", "Throw an exception when encountering null map keys."),
        DROP("drop", "Drop entries with null keys from the map."),
        LITERAL("literal", "Replace null keys with a literal string value.");

        private final String value;
        private final String description;

        private MapNullKeyMode(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }

        public String getValue() {
            return this.value;
        }
    }
}

