/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.util.List;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexPathFactory;
import org.apache.paimon.utils.IntFileUtils;
import org.apache.paimon.utils.IntIterator;

public class HashIndexFile
extends IndexFile {
    public static final String HASH_INDEX = "HASH";

    public HashIndexFile(FileIO fileIO, IndexPathFactory pathFactory) {
        super(fileIO, pathFactory);
    }

    public IntIterator read(IndexFileMeta file) throws IOException {
        return IntFileUtils.readInts(this.fileIO, this.pathFactory.toPath(file));
    }

    public List<Integer> readList(IndexFileMeta file) throws IOException {
        return IntIterator.toIntList(this.read(file));
    }

    public IndexFileMeta write(IntIterator input) throws IOException {
        Path path = this.pathFactory.newPath();
        int count = IntFileUtils.writeInts(this.fileIO, path, input);
        return new IndexFileMeta(HASH_INDEX, path.getName(), this.fileSize(path), count, null, this.isExternalPath() ? path.toString() : null);
    }

    public IndexFileMeta write(int[] ints) throws IOException {
        return this.write(IntIterator.create(ints));
    }
}

