/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.util.Comparator;
import org.apache.paimon.lookup.sort.BlockAlignedType;
import org.apache.paimon.lookup.sort.BlockIterator;
import org.apache.paimon.memory.MemorySlice;

public class BlockReader {
    private final MemorySlice block;
    private final Comparator<MemorySlice> comparator;

    public BlockReader(MemorySlice block, Comparator<MemorySlice> comparator) {
        this.block = block;
        this.comparator = comparator;
    }

    public long size() {
        return this.block.length();
    }

    public BlockIterator iterator() {
        BlockAlignedType alignedType = BlockAlignedType.fromByte(this.block.readByte(this.block.length() - 1));
        int intValue = this.block.readInt(this.block.length() - 5);
        if (alignedType == BlockAlignedType.ALIGNED) {
            return new AlignedIterator(this.block.slice(0, this.block.length() - 5), intValue, this.comparator);
        }
        int indexLength = intValue * 4;
        int indexOffset = this.block.length() - 5 - indexLength;
        MemorySlice data = this.block.slice(0, indexOffset);
        MemorySlice index = this.block.slice(indexOffset, indexLength);
        return new UnalignedIterator(data, index, this.comparator);
    }

    private static class UnalignedIterator
    extends BlockIterator {
        private final MemorySlice index;

        public UnalignedIterator(MemorySlice data, MemorySlice index, Comparator<MemorySlice> comparator) {
            super(data.toInput(), index.length() / 4, comparator);
            this.index = index;
        }

        @Override
        public void seekTo(int record) {
            this.data.setPosition(this.index.readInt(record * 4));
        }
    }

    private static class AlignedIterator
    extends BlockIterator {
        private final int recordSize;

        public AlignedIterator(MemorySlice data, int recordSize, Comparator<MemorySlice> comparator) {
            super(data.toInput(), data.length() / recordSize, comparator);
            this.recordSize = recordSize;
        }

        @Override
        public void seekTo(int record) {
            this.data.setPosition(record * this.recordSize);
        }
    }
}

