/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import java.util.List;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.avro.AvroSchemaVisitor;
import org.apache.paimon.format.avro.FieldWriter;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.io.Encoder;
import org.apache.paimon.shade.org.apache.avro.util.Utf8;
import org.apache.paimon.types.DataType;

public class FieldWriterFactory
implements AvroSchemaVisitor<FieldWriter> {
    private static final FieldWriter STRING_WRITER = (container, i, encoder) -> encoder.writeString(new Utf8(container.getString(i).toBytes()));
    private static final FieldWriter BYTES_WRITER = (container, i, encoder) -> encoder.writeBytes(container.getBinary(i));
    private static final FieldWriter BOOLEAN_WRITER = (container, i, encoder) -> encoder.writeBoolean(container.getBoolean(i));
    private static final FieldWriter INT_WRITER = (container, i, encoder) -> encoder.writeInt(container.getInt(i));
    private static final FieldWriter TINYINT_WRITER = (container, i, encoder) -> encoder.writeInt(container.getByte(i));
    private static final FieldWriter SMALLINT_WRITER = (container, i, encoder) -> encoder.writeInt(container.getShort(i));
    private static final FieldWriter BIGINT_WRITER = (container, i, encoder) -> encoder.writeLong(container.getLong(i));
    private static final FieldWriter FLOAT_WRITER = (container, i, encoder) -> encoder.writeFloat(container.getFloat(i));
    private static final FieldWriter DOUBLE_WRITER = (container, i, encoder) -> encoder.writeDouble(container.getDouble(i));

    @Override
    public FieldWriter visitUnion(Schema schema, DataType type) {
        return new NullableWriter((FieldWriter)this.visit(schema.getTypes().get(1), type));
    }

    @Override
    public FieldWriter visitString() {
        return STRING_WRITER;
    }

    @Override
    public FieldWriter visitBytes() {
        return BYTES_WRITER;
    }

    @Override
    public FieldWriter visitInt() {
        return INT_WRITER;
    }

    @Override
    public FieldWriter visitTinyInt() {
        return TINYINT_WRITER;
    }

    @Override
    public FieldWriter visitSmallInt() {
        return SMALLINT_WRITER;
    }

    @Override
    public FieldWriter visitBoolean() {
        return BOOLEAN_WRITER;
    }

    @Override
    public FieldWriter visitBigInt() {
        return BIGINT_WRITER;
    }

    @Override
    public FieldWriter visitFloat() {
        return FLOAT_WRITER;
    }

    @Override
    public FieldWriter visitDouble() {
        return DOUBLE_WRITER;
    }

    @Override
    public FieldWriter visitTimestampMillis(int precision) {
        return (container, i, encoder) -> encoder.writeLong(container.getTimestamp(i, precision).getMillisecond());
    }

    @Override
    public FieldWriter visitTimestampMicros(int precision) {
        return (container, i, encoder) -> encoder.writeLong(container.getTimestamp(i, precision).toMicros());
    }

    @Override
    public FieldWriter visitDecimal(int precision, int scale) {
        return (container, index, encoder) -> {
            Decimal decimal = container.getDecimal(index, precision, scale);
            encoder.writeBytes(decimal.toUnscaledBytes());
        };
    }

    @Override
    public FieldWriter visitArray(Schema schema, DataType elementType) {
        FieldWriter elementWriter = (FieldWriter)this.visit(schema.getElementType(), elementType);
        return (container, index, encoder) -> {
            InternalArray array = container.getArray(index);
            encoder.writeArrayStart();
            int numElements = array.size();
            encoder.setItemCount(numElements);
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                elementWriter.write((DataGetters)array, i, encoder);
            }
            encoder.writeArrayEnd();
        };
    }

    @Override
    public FieldWriter visitMap(Schema schema, DataType valueType) {
        FieldWriter valueWriter = (FieldWriter)this.visit(schema.getValueType(), valueType);
        return (container, index, encoder) -> {
            InternalMap map = container.getMap(index);
            encoder.writeMapStart();
            int numElements = map.size();
            encoder.setItemCount(numElements);
            InternalArray keyArray = map.keyArray();
            InternalArray valueArray = map.valueArray();
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                STRING_WRITER.write((DataGetters)keyArray, i, encoder);
                valueWriter.write((DataGetters)valueArray, i, encoder);
            }
            encoder.writeMapEnd();
        };
    }

    @Override
    public FieldWriter visitRecord(Schema schema, List<DataType> fieldTypes) {
        return new RowWriter(schema, fieldTypes);
    }

    public RowWriter createRowWriter(Schema schema, List<DataType> fieldTypes) {
        return new RowWriter(schema, fieldTypes);
    }

    public class RowWriter
    implements FieldWriter {
        private final FieldWriter[] fieldWriters;

        private RowWriter(Schema schema, List<DataType> fieldTypes) {
            List<Schema.Field> schemaFields = schema.getFields();
            this.fieldWriters = new FieldWriter[schemaFields.size()];
            int fieldsSize = schemaFields.size();
            for (int i = 0; i < fieldsSize; ++i) {
                Schema.Field field = schemaFields.get(i);
                DataType type = fieldTypes.get(i);
                this.fieldWriters[i] = (FieldWriter)FieldWriterFactory.this.visit(field.schema(), type);
            }
        }

        @Override
        public void write(DataGetters container, int index, Encoder encoder) throws IOException {
            InternalRow row = container.getRow(index, this.fieldWriters.length);
            this.writeRow(row, encoder);
        }

        public void writeRow(InternalRow row, Encoder encoder) throws IOException {
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                this.fieldWriters[i].write((DataGetters)row, i, encoder);
            }
        }
    }

    private static class NullableWriter
    implements FieldWriter {
        private final FieldWriter writer;

        public NullableWriter(FieldWriter writer) {
            this.writer = writer;
        }

        @Override
        public void write(DataGetters container, int index, Encoder encoder) throws IOException {
            if (container.isNullAt(index)) {
                encoder.writeIndex(0);
            } else {
                encoder.writeIndex(1);
                this.writer.write(container, index, encoder);
            }
        }
    }
}

