/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.io.airlift.compress.lzo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.HadoopLzopInputStream;
import org.apache.paimon.shade.io.airlift.compress.lzo.HadoopLzopOutputStream;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoCodec;

public class LzopCodec
implements Configurable,
CompressionCodec {
    static final byte[] LZOP_MAGIC = new byte[]{-119, 76, 90, 79, 0, 13, 10, 26, 10};
    static final int LZOP_IMPLEMENTATION_VERSION = 4112;
    static final byte LZO_1X_VARIANT = 1;
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopLzopOutputStream(out, this.getBufferSize());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new HadoopLzopOutputStream(out, this.getBufferSize());
    }

    public Class<? extends Compressor> getCompressorType() {
        throw new UnsupportedOperationException();
    }

    public Compressor createCompressor() {
        return new LzoCodec.HadoopLzoCompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopLzopInputStream(in, this.getBufferSize());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new HadoopLzopInputStream(in, this.getBufferSize());
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return LzoCodec.HadoopLzoDecompressor.class;
    }

    public Decompressor createDecompressor() {
        return new LzoCodec.HadoopLzoDecompressor();
    }

    public String getDefaultExtension() {
        return ".lzo";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.lzo.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }
}

