/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.com.google.protobuf.CodedOutputStream;
import org.apache.paimon.shade.org.apache.orc.CompressionCodec;
import org.apache.paimon.shade.org.apache.orc.CompressionKind;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.PhysicalWriter;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShims;
import org.apache.paimon.shade.org.apache.orc.impl.OrcCodecPool;
import org.apache.paimon.shade.org.apache.orc.impl.OutStream;
import org.apache.paimon.shade.org.apache.orc.impl.StreamName;
import org.apache.paimon.shade.org.apache.orc.impl.WriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFsWriter
implements PhysicalWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalFsWriter.class);
    private static final int HDFS_BUFFER_SIZE = 262144;
    private FSDataOutputStream rawWriter;
    private OutStream writer;
    private CodedOutputStream protobufWriter;
    private final Path path;
    private final HadoopShims shims;
    private final long blockSize;
    private final int bufferSize;
    private final int maxPadding;
    private final CompressionKind compress;
    private CompressionCodec codec;
    private final boolean addBlockPadding;
    private final boolean writeVariableLengthBlocks;
    private final Map<StreamName, BufferedStream> streams = new TreeMap<StreamName, BufferedStream>();
    private long headerLength;
    private long stripeStart;
    private long blockOffset;
    private int metadataLength;
    private int footerLength;
    private static final byte[] ZEROS = new byte[65536];

    public PhysicalFsWriter(FileSystem fs, Path path, OrcFile.WriterOptions opts) throws IOException {
        this.path = path;
        long defaultStripeSize = opts.getStripeSize();
        this.addBlockPadding = opts.getBlockPadding();
        this.bufferSize = opts.isEnforceBufferSize() ? opts.getBufferSize() : WriterImpl.getEstimatedBufferSize(defaultStripeSize, opts.getSchema().getMaximumId() + 1, opts.getBufferSize());
        this.compress = opts.getCompress();
        this.maxPadding = (int)(opts.getPaddingTolerance() * (double)defaultStripeSize);
        this.blockSize = opts.getBlockSize();
        LOG.info("ORC writer created for path: {} with stripeSize: {} blockSize: {} compression: {} bufferSize: {}", new Object[]{path, defaultStripeSize, this.blockSize, this.compress, this.bufferSize});
        this.rawWriter = fs.create(path, opts.getOverwrite(), 262144, fs.getDefaultReplication(path), this.blockSize);
        this.blockOffset = 0L;
        this.codec = OrcCodecPool.getCodec(this.compress);
        this.writer = new OutStream("metadata", this.bufferSize, this.codec, new DirectStream(this.rawWriter));
        this.protobufWriter = CodedOutputStream.newInstance(this.writer);
        this.writeVariableLengthBlocks = opts.getWriteVariableLengthBlocks();
        this.shims = opts.getHadoopShims();
    }

    @Override
    public CompressionCodec getCompressionCodec() {
        return this.codec;
    }

    @Override
    public long getFileBytes(int column) {
        long size = 0L;
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            StreamName name;
            BufferedStream receiver = pair.getValue();
            if (receiver.isSuppressed || (name = pair.getKey()).getColumn() != column || name.getArea() == StreamName.Area.INDEX) continue;
            size += receiver.getOutputSize();
        }
        return size;
    }

    private static void writeZeros(OutputStream output, long remaining) throws IOException {
        while (remaining > 0L) {
            long size = Math.min((long)ZEROS.length, remaining);
            output.write(ZEROS, 0, (int)size);
            remaining -= size;
        }
    }

    private void padStripe(long stripeSize) throws IOException {
        this.stripeStart = this.rawWriter.getPos();
        long previousBytesInBlock = (this.stripeStart - this.blockOffset) % this.blockSize;
        if (previousBytesInBlock > 0L && previousBytesInBlock + stripeSize >= this.blockSize) {
            long padding;
            if (this.writeVariableLengthBlocks && this.shims.endVariableLengthBlock((OutputStream)this.rawWriter)) {
                this.blockOffset = this.stripeStart;
            } else if (this.addBlockPadding && (padding = this.blockSize - previousBytesInBlock) <= (long)this.maxPadding) {
                PhysicalFsWriter.writeZeros((OutputStream)this.rawWriter, padding);
                this.stripeStart += padding;
            }
        }
    }

    private void writeStripeFooter(OrcProto.StripeFooter footer, long dataSize, long indexSize, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        dirEntry.setOffset(this.stripeStart);
        dirEntry.setFooterLength(this.rawWriter.getPos() - this.stripeStart - dataSize - indexSize);
    }

    @Override
    public void writeFileMetadata(OrcProto.Metadata.Builder builder) throws IOException {
        long startPosn = this.rawWriter.getPos();
        OrcProto.Metadata metadata = builder.build();
        metadata.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        this.metadataLength = (int)(this.rawWriter.getPos() - startPosn);
    }

    @Override
    public void writeFileFooter(OrcProto.Footer.Builder builder) throws IOException {
        long bodyLength = this.rawWriter.getPos() - (long)this.metadataLength;
        builder.setContentLength(bodyLength);
        builder.setHeaderLength(this.headerLength);
        long startPosn = this.rawWriter.getPos();
        OrcProto.Footer footer = builder.build();
        footer.writeTo(this.protobufWriter);
        this.protobufWriter.flush();
        this.writer.flush();
        this.footerLength = (int)(this.rawWriter.getPos() - startPosn);
    }

    @Override
    public long writePostScript(OrcProto.PostScript.Builder builder) throws IOException {
        builder.setFooterLength(this.footerLength);
        builder.setMetadataLength(this.metadataLength);
        OrcProto.PostScript ps = builder.build();
        long startPosn = this.rawWriter.getPos();
        ps.writeTo((OutputStream)this.rawWriter);
        long length = this.rawWriter.getPos() - startPosn;
        if (length > 255L) {
            throw new IllegalArgumentException("PostScript too large at " + length);
        }
        this.rawWriter.writeByte((int)length);
        return this.rawWriter.getPos();
    }

    @Override
    public void close() throws IOException {
        OrcCodecPool.returnCodec(this.compress, this.codec);
        this.codec = null;
        this.rawWriter.close();
        this.rawWriter = null;
    }

    @Override
    public void flush() throws IOException {
        this.rawWriter.hflush();
    }

    @Override
    public void appendRawStripe(ByteBuffer buffer, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        long start = this.rawWriter.getPos();
        int length = buffer.remaining();
        long availBlockSpace = this.blockSize - start % this.blockSize;
        if ((long)length < this.blockSize && (long)length > availBlockSpace && this.addBlockPadding) {
            byte[] pad = new byte[(int)Math.min(262144L, availBlockSpace)];
            LOG.info(String.format("Padding ORC by %d bytes while merging..", availBlockSpace));
            start += availBlockSpace;
            while (availBlockSpace > 0L) {
                int writeLen = (int)Math.min(availBlockSpace, (long)pad.length);
                this.rawWriter.write(pad, 0, writeLen);
                availBlockSpace -= (long)writeLen;
            }
        }
        this.rawWriter.write(buffer.array(), buffer.arrayOffset() + buffer.position(), length);
        dirEntry.setOffset(start);
    }

    @Override
    public void finalizeStripe(OrcProto.StripeFooter.Builder footerBuilder, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
        long indexSize = 0L;
        long dataSize = 0L;
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            BufferedStream receiver = pair.getValue();
            if (receiver.isSuppressed) continue;
            long streamSize = receiver.getOutputSize();
            StreamName name = pair.getKey();
            footerBuilder.addStreams(OrcProto.Stream.newBuilder().setColumn(name.getColumn()).setKind(name.getKind()).setLength(streamSize));
            if (StreamName.Area.INDEX == name.getArea()) {
                indexSize += streamSize;
                continue;
            }
            dataSize += streamSize;
        }
        dirEntry.setIndexLength(indexSize).setDataLength(dataSize);
        OrcProto.StripeFooter footer = footerBuilder.build();
        this.padStripe(indexSize + dataSize + (long)footer.getSerializedSize());
        for (Map.Entry<StreamName, BufferedStream> pair : this.streams.entrySet()) {
            pair.getValue().spillToDiskAndClear(this.rawWriter);
        }
        this.writeStripeFooter(footer, dataSize, indexSize, dirEntry);
    }

    @Override
    public void writeHeader() throws IOException {
        this.rawWriter.writeBytes("ORC");
        this.headerLength = this.rawWriter.getPos();
    }

    @Override
    public BufferedStream createDataStream(StreamName name) {
        BufferedStream result = this.streams.get(name);
        if (result == null) {
            result = new BufferedStream();
            this.streams.put(name, result);
        }
        return result;
    }

    @Override
    public void writeIndex(StreamName name, OrcProto.RowIndex.Builder index, CompressionCodec codec) throws IOException {
        OutStream stream = new OutStream(this.path.toString(), this.bufferSize, codec, this.createDataStream(name));
        index.build().writeTo(stream);
        ((OutputStream)stream).flush();
    }

    @Override
    public void writeBloomFilter(StreamName name, OrcProto.BloomFilterIndex.Builder bloom, CompressionCodec codec) throws IOException {
        OutStream stream = new OutStream(this.path.toString(), this.bufferSize, codec, this.createDataStream(name));
        bloom.build().writeTo(stream);
        ((OutputStream)stream).flush();
    }

    public String toString() {
        return this.path.toString();
    }

    private static final class BufferedStream
    implements PhysicalWriter.OutputReceiver {
        private boolean isSuppressed = false;
        private final List<ByteBuffer> output = new ArrayList<ByteBuffer>();

        private BufferedStream() {
        }

        @Override
        public void output(ByteBuffer buffer) {
            if (!this.isSuppressed) {
                this.output.add(buffer);
            }
        }

        @Override
        public void suppress() {
            this.isSuppressed = true;
            this.output.clear();
        }

        void spillToDiskAndClear(FSDataOutputStream raw) throws IOException {
            if (!this.isSuppressed) {
                for (ByteBuffer buffer : this.output) {
                    raw.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                }
                this.output.clear();
            }
            this.isSuppressed = false;
        }

        public long getOutputSize() {
            long result = 0L;
            for (ByteBuffer buffer : this.output) {
                result += (long)buffer.remaining();
            }
            return result;
        }
    }

    private static class DirectStream
    implements PhysicalWriter.OutputReceiver {
        private final FSDataOutputStream output;

        DirectStream(FSDataOutputStream output) {
            this.output = output;
        }

        @Override
        public void output(ByteBuffer buffer) throws IOException {
            this.output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }

        @Override
        public void suppress() {
            throw new UnsupportedOperationException("Can't suppress direct stream");
        }
    }
}

