/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.paimon.shade.org.apache.orc.FileFormatException;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.ParserUtils;
import org.apache.paimon.shade.org.apache.orc.impl.ReaderImpl;
import org.apache.paimon.shade.org.apache.orc.impl.SchemaEvolution;

public class OrcUtils {
    public static boolean[] includeColumns(String selectedColumns, TypeDescription schema) {
        TypeDescription baseSchema;
        int numFlattenedCols = schema.getMaximumId();
        boolean[] results = new boolean[numFlattenedCols + 1];
        if ("*".equals(selectedColumns)) {
            Arrays.fill(results, true);
            return results;
        }
        TypeDescription typeDescription = baseSchema = SchemaEvolution.checkAcidSchema(schema) ? SchemaEvolution.getBaseRow(schema) : schema;
        if (selectedColumns != null && baseSchema.getCategory() == TypeDescription.Category.STRUCT) {
            for (String columnName : selectedColumns.split(",")) {
                TypeDescription column = OrcUtils.findColumn(baseSchema, columnName.trim());
                if (column == null) continue;
                for (int i = column.getId(); i <= column.getMaximumId(); ++i) {
                    results[i] = true;
                }
            }
        }
        return results;
    }

    private static TypeDescription findColumn(TypeDescription schema, String column) {
        TypeDescription result = schema;
        String[] columnMatcher = column.split("\\.");
        int index = 0;
        while (index < columnMatcher.length && result.getCategory() == TypeDescription.Category.STRUCT) {
            String columnName = columnMatcher[index];
            int prevIndex = index;
            List<TypeDescription> fields = result.getChildren();
            List<String> fieldNames = result.getFieldNames();
            for (int i = 0; i < fields.size(); ++i) {
                if (!columnName.equalsIgnoreCase(fieldNames.get(i))) continue;
                result = fields.get(i);
                ++index;
                break;
            }
            if (prevIndex != index) continue;
            return null;
        }
        return result;
    }

    public static List<OrcProto.Type> getOrcTypes(TypeDescription typeDescr) {
        ArrayList<OrcProto.Type> result = new ArrayList<OrcProto.Type>();
        OrcUtils.appendOrcTypes(result, typeDescr);
        return result;
    }

    private static void appendOrcTypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        List<TypeDescription> children = typeDescr.getChildren();
        for (String key : typeDescr.getAttributeNames()) {
            type.addAttributes(OrcProto.StringPair.newBuilder().setKey(key).setValue(typeDescr.getAttributeValue(key)).build());
        }
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case TIMESTAMP_INSTANT: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP_INSTANT);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(children.get(0).getId());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                for (String field : typeDescr.getFieldNames()) {
                    type.addFieldNames(field);
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        result.add(type.build());
        if (children != null) {
            for (TypeDescription child : children) {
                OrcUtils.appendOrcTypes(result, child);
            }
        }
    }

    public static int isValidTypeTree(List<OrcProto.Type> types, int root) throws IOException {
        if (root < 0 || root >= types.size()) {
            throw new IOException("Illegal type id " + root + ". The valid range is 0 to " + (types.size() - 1));
        }
        OrcProto.Type rootType = types.get(root);
        int current = root + 1;
        List<Integer> children = rootType.getSubtypesList();
        if (!rootType.hasKind()) {
            throw new IOException("Type " + root + " has an unknown kind.");
        }
        switch (rootType.getKind()) {
            case LIST: {
                if (children != null && children.size() == 1) break;
                throw new IOException("Wrong number of type children in list " + root);
            }
            case MAP: {
                if (children != null && children.size() == 2) break;
                throw new IOException("Wrong number of type children in map " + root);
            }
            case UNION: 
            case STRUCT: {
                break;
            }
            default: {
                if (children == null || children.size() == 0) break;
                throw new IOException("Type children under primitive type " + root);
            }
        }
        if (children != null) {
            for (int child : children) {
                if (child != current) {
                    throw new IOException("Unexpected child type id " + child + " when " + current + " was expected.");
                }
                current = OrcUtils.isValidTypeTree(types, current);
            }
        }
        return current;
    }

    public static TypeDescription convertTypeFromProtobuf(List<OrcProto.Type> types, int rootColumn) throws FileFormatException {
        TypeDescription result;
        OrcProto.Type type = types.get(rootColumn);
        switch (type.getKind()) {
            case BOOLEAN: {
                result = TypeDescription.createBoolean();
                break;
            }
            case BYTE: {
                result = TypeDescription.createByte();
                break;
            }
            case SHORT: {
                result = TypeDescription.createShort();
                break;
            }
            case INT: {
                result = TypeDescription.createInt();
                break;
            }
            case LONG: {
                result = TypeDescription.createLong();
                break;
            }
            case FLOAT: {
                result = TypeDescription.createFloat();
                break;
            }
            case DOUBLE: {
                result = TypeDescription.createDouble();
                break;
            }
            case STRING: {
                result = TypeDescription.createString();
                break;
            }
            case CHAR: 
            case VARCHAR: {
                TypeDescription typeDescription = result = type.getKind() == OrcProto.Type.Kind.CHAR ? TypeDescription.createChar() : TypeDescription.createVarchar();
                if (!type.hasMaximumLength()) break;
                result.withMaxLength(type.getMaximumLength());
                break;
            }
            case BINARY: {
                result = TypeDescription.createBinary();
                break;
            }
            case TIMESTAMP: {
                result = TypeDescription.createTimestamp();
                break;
            }
            case TIMESTAMP_INSTANT: {
                result = TypeDescription.createTimestampInstant();
                break;
            }
            case DATE: {
                result = TypeDescription.createDate();
                break;
            }
            case DECIMAL: {
                result = TypeDescription.createDecimal();
                if (type.hasScale()) {
                    result.withScale(type.getScale());
                }
                if (!type.hasPrecision()) break;
                result.withPrecision(type.getPrecision());
                break;
            }
            case LIST: {
                if (type.getSubtypesCount() != 1) {
                    throw new FileFormatException("LIST type should contain exactly one subtype but has " + type.getSubtypesCount());
                }
                result = TypeDescription.createList(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)));
                break;
            }
            case MAP: {
                if (type.getSubtypesCount() != 2) {
                    throw new FileFormatException("MAP type should contain exactly two subtypes but has " + type.getSubtypesCount());
                }
                result = TypeDescription.createMap(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)), OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(1)));
                break;
            }
            case STRUCT: {
                int f;
                result = TypeDescription.createStruct();
                for (f = 0; f < type.getSubtypesCount(); ++f) {
                    String name = type.getFieldNames(f);
                    name = name.startsWith("`") ? name : "`" + name + "`";
                    String fieldName = ParserUtils.parseName(new ParserUtils.StringPosition(name));
                    result.addField(fieldName, OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                break;
            }
            case UNION: {
                int f;
                if (type.getSubtypesCount() == 0) {
                    throw new FileFormatException("UNION type should contain at least one subtype but has none");
                }
                result = TypeDescription.createUnion();
                for (f = 0; f < type.getSubtypesCount(); ++f) {
                    result.addUnionChild(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ORC type " + type.getKind());
            }
        }
        for (int i = 0; i < type.getAttributesCount(); ++i) {
            OrcProto.StringPair pair = type.getAttributes(i);
            result.setAttribute(pair.getKey(), pair.getValue());
        }
        return result;
    }

    public static List<StripeInformation> convertProtoStripesToStripes(List<OrcProto.StripeInformation> stripes) {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(stripes.size());
        long previousStripeId = 0L;
        byte[][] previousKeys = null;
        long stripeId = 0L;
        for (OrcProto.StripeInformation stripeProto : stripes) {
            ReaderImpl.StripeInformationImpl stripe = new ReaderImpl.StripeInformationImpl(stripeProto, stripeId++, previousStripeId, previousKeys);
            result.add(stripe);
            previousStripeId = stripe.getEncryptionStripeId();
            previousKeys = stripe.getEncryptedLocalKeys();
        }
        return result;
    }

    public static String getSoftwareVersion(int writer, String version) {
        String base;
        switch (writer) {
            case 0: {
                base = "ORC Java";
                break;
            }
            case 1: {
                base = "ORC C++";
                break;
            }
            case 2: {
                base = "Presto";
                break;
            }
            case 3: {
                base = "Scritchley Go";
                break;
            }
            case 4: {
                base = "Trino";
                break;
            }
            default: {
                base = String.format("Unknown(%d)", writer);
            }
        }
        if (version == null) {
            return base;
        }
        return base + " " + version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOrcVersion() {
        Class<OrcFile> cls = OrcFile.class;
        try (InputStream is2222 = cls.getResourceAsStream("/META-INF/maven/org.apache.orc/orc-core/pom.properties");){
            if (is2222 != null) {
                Properties p = new Properties();
                p.load(is2222);
                String version2 = p.getProperty("version", null);
                if (version2 != null) {
                    String string = version2;
                    return string;
                }
            }
        }
        catch (IOException is2222) {
            // empty catch block
        }
        Package aPackage = cls.getPackage();
        if (aPackage == null) return "unknown";
        String version = aPackage.getImplementationVersion();
        if (version == null) return "unknown";
        return version;
    }
}

