/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.format.orc.OrcReaderFactory;
import org.apache.paimon.format.orc.OrcWriterFactory;
import org.apache.paimon.format.orc.filter.OrcFilters;
import org.apache.paimon.format.orc.filter.OrcPredicateFunctionVisitor;
import org.apache.paimon.format.orc.filter.OrcTableStatsExtractor;
import org.apache.paimon.format.orc.reader.OrcSplitReaderUtil;
import org.apache.paimon.format.orc.writer.RowDataVectorizer;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;

@ThreadSafe
public class OrcFileFormat
extends FileFormat {
    public static final String IDENTIFIER = "orc";
    private final Properties orcProperties;
    private final Configuration readerConf;
    private final Configuration writerConf;
    private final FileFormatFactory.FormatContext formatContext;

    public OrcFileFormat(FileFormatFactory.FormatContext formatContext) {
        super(IDENTIFIER);
        this.orcProperties = OrcFileFormat.getOrcProperties(formatContext.formatOptions());
        this.readerConf = new Configuration();
        this.orcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.readerConf.set(k.toString(), v.toString())));
        this.writerConf = new Configuration();
        this.orcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.writerConf.set(k.toString(), v.toString())));
        this.formatContext = formatContext;
    }

    @VisibleForTesting
    Properties orcProperties() {
        return this.orcProperties;
    }

    @VisibleForTesting
    public FileFormatFactory.FormatContext formatContext() {
        return this.formatContext;
    }

    public Optional<TableStatsExtractor> createStatsExtractor(RowType type, FieldStatsCollector.Factory[] statsCollectors) {
        return Optional.of(new OrcTableStatsExtractor(type, statsCollectors));
    }

    public FormatReaderFactory createReaderFactory(RowType projectedRowType, @Nullable List<Predicate> filters) {
        ArrayList<OrcFilters.Predicate> orcPredicates = new ArrayList<OrcFilters.Predicate>();
        if (filters != null) {
            for (Predicate pred : filters) {
                Optional orcPred = (Optional)pred.visit((PredicateVisitor)OrcPredicateFunctionVisitor.VISITOR);
                orcPred.ifPresent(orcPredicates::add);
            }
        }
        return new OrcReaderFactory(this.readerConf, (RowType)OrcFileFormat.refineDataType((DataType)projectedRowType), orcPredicates, this.formatContext.readBatchSize());
    }

    public void validateDataFields(RowType rowType) {
        DataType refinedType = OrcFileFormat.refineDataType((DataType)rowType);
        OrcSplitReaderUtil.toOrcType(refinedType);
    }

    public FormatWriterFactory createWriterFactory(RowType type) {
        DataType refinedType = OrcFileFormat.refineDataType((DataType)type);
        DataType[] orcTypes = DataTypeChecks.getFieldTypes((DataType)refinedType).toArray(new DataType[0]);
        TypeDescription typeDescription = OrcSplitReaderUtil.toOrcType(refinedType);
        RowDataVectorizer vectorizer = new RowDataVectorizer(typeDescription.toString(), orcTypes);
        return new OrcWriterFactory(vectorizer, this.orcProperties, this.writerConf);
    }

    private static Properties getOrcProperties(Options options) {
        Properties orcProperties = new Properties();
        Properties properties = new Properties();
        options.addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> orcProperties.put("orc." + k, v)));
        return orcProperties;
    }

    private static DataType refineDataType(DataType type) {
        switch (type.getTypeRoot()) {
            case BINARY: 
            case VARBINARY: {
                return DataTypes.BYTES();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return new ArrayType(arrayType.isNullable(), OrcFileFormat.refineDataType(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new MapType(OrcFileFormat.refineDataType(mapType.getKeyType()), OrcFileFormat.refineDataType(mapType.getValueType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                return new MapType(OrcFileFormat.refineDataType(multisetType.getElementType()), OrcFileFormat.refineDataType((DataType)new IntType(false)));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new RowType(rowType.isNullable(), rowType.getFields().stream().map(f -> new DataField(f.id(), f.name(), OrcFileFormat.refineDataType(f.type()), f.description())).collect(Collectors.toList()));
            }
        }
        return type;
    }
}

